/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.util.serialize;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllowListLoader {
    private static final Logger log = LoggerFactory.getLogger(AllowListLoader.class);
    private final Set<String> commonAllowedClassesForSerialisation;

    public AllowListLoader(Set<String> commonAllowedClassesForSerialisation) {
        this.commonAllowedClassesForSerialisation = commonAllowedClassesForSerialisation;
    }

    public Set<String> loadAllowList(String allowListResource) {
        Stream commonClassesStream = this.commonAllowedClassesForSerialisation.stream();
        Stream<String> resourceClassesStream = this.readLinesFromStream(AllowListLoader.class.getClassLoader().getResourceAsStream(allowListResource));
        return Stream.concat(commonClassesStream, resourceClassesStream).collect(Collectors.toSet());
    }

    private Stream<String> readLinesFromStream(InputStream inputStream) {
        Stream<String> stream;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        try {
            stream = reader.lines().map(String::trim).filter(line -> !line.isEmpty() && !line.startsWith("#")).toList().stream();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                log.error("Error reading from allowlist stream", (Throwable)e);
                return Stream.empty();
            }
        }
        reader.close();
        return stream;
    }
}

