/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.util.serialize;

import com.atlassian.confluence.impl.util.serialize.exception.DisallowedClassException;
import com.atlassian.scheduler.core.util.ClassLoaderAwareObjectInputStream;
import java.io.IOException;
import java.io.ObjectStreamClass;
import java.util.function.Predicate;

public class SecureClassLoaderAwareObjectInputStream
extends ClassLoaderAwareObjectInputStream {
    private final Predicate<String> validator;

    public SecureClassLoaderAwareObjectInputStream(ClassLoader classLoader, byte[] parameters, Predicate<String> validator) throws IOException {
        super(classLoader, parameters);
        this.validator = validator;
    }

    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String className = desc.getName();
        if (!this.validator.test(className)) {
            throw new DisallowedClassException(className);
        }
        return super.resolveClass(desc);
    }
}

