/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.util.serialize;

import com.atlassian.confluence.impl.util.serialize.SecureClassLoaderAwareObjectInputStream;
import com.atlassian.scheduler.SchedulerServiceException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Set;

public class SecureObjectSerializer {
    private final Set<String> allowedClassNames;
    private final ClassLoader classLoader;

    public SecureObjectSerializer(Set<String> allowedClassNames, ClassLoader classLoader) {
        this.allowedClassNames = allowedClassNames;
        this.classLoader = classLoader;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] serialize(Serializable object) throws SchedulerServiceException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream out = new ObjectOutputStream(bos);){
                out.writeObject(object);
                byArray = bos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new SchedulerServiceException("Serialization failed", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"OBJECT_DESERIALIZATION"})
    public <T> T deserialize(byte[] bytes, Class<T> type) throws SchedulerServiceException {
        try (SecureClassLoaderAwareObjectInputStream in = new SecureClassLoaderAwareObjectInputStream(this.classLoader, bytes, this.allowedClassNames::contains);){
            Object obj = ((ObjectInputStream)((Object)in)).readObject();
            T t = type.cast(obj);
            return t;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new SchedulerServiceException("Deserialization failed", (Throwable)e);
        }
    }
}

