/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.velocity;

import com.atlassian.velocity.allowlist.uberspect.PluginAwareSecureIntrospector;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Set;
import org.apache.felix.framework.BundleWiringImpl;
import org.apache.struts2.action.Action;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.Log;

public class ConfluenceAllowlistIntrospector
extends PluginAwareSecureIntrospector {
    private final ClassLoader coreClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
    private final ClassLoader commonClassLoader = ConfluenceAllowlistIntrospector.getParentOrNull(this.coreClassLoader);
    private final ClassLoader systemClassLoader = ConfluenceAllowlistIntrospector.getParentOrNull(this.commonClassLoader);
    private final ClassLoader platformClassLoader = ConfluenceAllowlistIntrospector.getParentOrNull(this.systemClassLoader);
    private final ClassLoader bootClassLoader = ConfluenceAllowlistIntrospector.getParentOrNull(this.platformClassLoader);
    public static final String ANNOTATIONS_ENABLE_SYS_PROP = "velocity.allowlist.annotations.enable";

    public ConfluenceAllowlistIntrospector(Log log, RuntimeServices runtimeServices) {
        super(log, runtimeServices);
    }

    private static ClassLoader getParentOrNull(ClassLoader classLoader) {
        return classLoader != null ? classLoader.getParent() : null;
    }

    protected boolean isAllowlistedMethodInternal(Method method) {
        return super.isAllowlistedMethodInternal(method) || this.isMethodStrutsActionGetter(method) || this.isAnnotatedAllowlisted(method);
    }

    private boolean isMethodStrutsActionGetter(Method method) {
        return Action.class.isAssignableFrom(method.getDeclaringClass()) && method.getParameterCount() == 0 && (method.getName().startsWith("get") || method.getName().startsWith("is") && Set.of(Boolean.TYPE, Boolean.class).contains(method.getReturnType()));
    }

    protected String appendedToClassRelatedLogging(Class<?> clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        return " [%s] (%s)".formatted(this.getIdentifier(classLoader), Objects.toString(classLoader));
    }

    private String getIdentifier(ClassLoader classLoader) {
        if (this.coreClassLoader == classLoader) {
            return "webapp";
        }
        if (this.commonClassLoader != null && this.commonClassLoader == classLoader) {
            return "common";
        }
        if (this.systemClassLoader != null && this.systemClassLoader == classLoader) {
            return "system";
        }
        if (this.platformClassLoader != null && this.platformClassLoader == classLoader) {
            return "platform";
        }
        if (this.bootClassLoader == classLoader || null == classLoader) {
            return "boot";
        }
        if (classLoader instanceof BundleWiringImpl.BundleClassLoader) {
            BundleWiringImpl.BundleClassLoader bundleClassLoader = (BundleWiringImpl.BundleClassLoader)classLoader;
            return bundleClassLoader.getBundle().getSymbolicName();
        }
        if (classLoader.getName() != null) {
            return classLoader.getName();
        }
        return "unknown";
    }

    private boolean isAnnotatedAllowlisted(Method method) {
        return Boolean.parseBoolean(System.getProperty(ANNOTATIONS_ENABLE_SYS_PROP)) && method.getAnnotation(VelocityAllowlisted.class) != null;
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface VelocityAllowlisted {
    }
}

