/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.velocity;

import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheManager;
import com.atlassian.confluence.impl.velocity.ConfluenceAllowlistUberspector;
import com.atlassian.confluence.impl.velocity.VelocityEngineRenderingService;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.util.velocity.ConfluenceVelocityCacheConfigurator;
import com.atlassian.confluence.velocity.htmlsafe.ConfluenceEventCartridgeProcessor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.velocity.allowlist.api.GlobalMethodAllowlist;
import com.atlassian.velocity.allowlist.api.internal.PluginAllowlist;
import com.atlassian.velocity.allowlist.impl.VelocityGlobalMethodAllowlist;
import com.atlassian.velocity.allowlist.impl.internal.PluginAllowlistConfigurator;
import com.atlassian.velocity.allowlist.uberspect.PluginAwareSecureIntrospector;
import com.atlassian.velocity.htmlsafe.context.EventCartridgeProcessor;
import jakarta.annotation.Resource;
import java.util.Objects;
import org.apache.struts2.views.velocity.VelocityManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
public class VelocityConfig {
    @Resource
    CacheManager cacheManager;
    @Resource
    GlobalSettingsManager globalSettingsManager;
    @Resource
    VelocityManager velocityManager;
    @Resource
    PluginEventManager pluginEventManager;
    @Resource
    PluginAccessor pluginAccessor;

    @Bean
    EventCartridgeProcessor confluenceEventCartridgeProcessor() {
        return new ConfluenceEventCartridgeProcessor();
    }

    @AvailableToPlugins
    @Bean
    VelocityHelperService velocityHelperService() {
        return new VelocityEngineRenderingService(this.confluenceEventCartridgeProcessor(), this.globalSettingsManager, this.velocityManager.getVelocityEngine());
    }

    @Bean
    ConfluenceVelocityCacheConfigurator velocityCacheConfigurator() {
        return new ConfluenceVelocityCacheConfigurator((CacheFactory)this.cacheManager);
    }

    @Bean
    PluginAllowlist pluginAllowlistConfigurator() {
        return new PluginAllowlistConfigurator(this.pluginAccessor);
    }

    @DependsOn(value={"velocityManager"})
    @Bean
    PluginAwareSecureIntrospector velocityIntrospector() {
        PluginAwareSecureIntrospector introspector = (PluginAwareSecureIntrospector)Objects.requireNonNull(new ConfluenceAllowlistUberspector().getIntrospector());
        introspector.setPluginAllowlist(this.pluginAllowlistConfigurator());
        this.pluginEventManager.register((Object)introspector);
        return introspector;
    }

    @AvailableToPlugins
    @Bean
    GlobalMethodAllowlist globalMethodAllowlist() {
        return new VelocityGlobalMethodAllowlist(this.velocityIntrospector());
    }
}

