/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.webresource;

import com.atlassian.confluence.event.events.admin.SiteDarkFeatureDisabledEvent;
import com.atlassian.confluence.event.events.admin.SiteDarkFeatureEnabledEvent;
import com.atlassian.confluence.event.events.cluster.ClusterEvent;
import com.atlassian.confluence.event.events.cluster.ClusterEventWrapper;
import com.atlassian.confluence.event.events.plugin.PluginFrameworkStartedEvent;
import com.atlassian.confluence.impl.osgi.OsgiNoServiceAvailableException;
import com.atlassian.confluence.internal.license.EnterpriseFeatureFlag;
import com.atlassian.confluence.setup.settings.DarkFeaturesManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.webresource.cdn.CDNStrategy;
import com.atlassian.plugin.webresource.cdn.CdnStrategyProvider;
import com.google.common.base.Supplier;
import io.atlassian.util.concurrent.Lazy;
import io.atlassian.util.concurrent.ResettableLazyReference;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.concurrent.atomic.AtomicBoolean;

public class ConfluenceCDNStrategyFactory
implements Supplier<CDNStrategy> {
    public static final String ATLASSIAN_CDN_FEATURE_FLAG = "atlassian.cdn.static.assets";
    private final EventPublisher eventPublisher;
    private final CdnStrategyProvider cdnStrategyProvider;
    private final EnterpriseFeatureFlag enterpriseFeatureFlag;
    private final AtomicBoolean isFinishedPluginFrameworkStartup;
    private final ResettableLazyReference<Boolean> isCdnFunctionalityAvailable;

    public ConfluenceCDNStrategyFactory(DarkFeaturesManager darkFeaturesManager, EventPublisher eventPublisher, CdnStrategyProvider cdnStrategyProvider, EnterpriseFeatureFlag enterpriseFeatureFlag) {
        this.eventPublisher = eventPublisher;
        this.cdnStrategyProvider = cdnStrategyProvider;
        this.enterpriseFeatureFlag = enterpriseFeatureFlag;
        this.isFinishedPluginFrameworkStartup = new AtomicBoolean();
        this.isCdnFunctionalityAvailable = Lazy.resettable(() -> this.isFinishedPluginFrameworkStartup.get() && darkFeaturesManager.getSiteDarkFeatures().isFeatureEnabled(ATLASSIAN_CDN_FEATURE_FLAG));
    }

    @PostConstruct
    public void init() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    public CDNStrategy get() {
        if (((Boolean)this.isCdnFunctionalityAvailable.get()).booleanValue() && this.enterpriseFeatureFlag.isEnabled()) {
            try {
                return this.cdnStrategyProvider.getCdnStrategy().orElse(null);
            }
            catch (OsgiNoServiceAvailableException e) {
                return null;
            }
        }
        return null;
    }

    @EventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent event) {
        this.isFinishedPluginFrameworkStartup.set(true);
        this.isCdnFunctionalityAvailable.reset();
    }

    @EventListener
    public void onSiteDarkFeatureEnabled(SiteDarkFeatureEnabledEvent event) {
        this.isCdnFunctionalityAvailable.reset();
    }

    @EventListener
    public void onSiteDarkFeatureDisabled(SiteDarkFeatureDisabledEvent event) {
        this.isCdnFunctionalityAvailable.reset();
    }

    @EventListener
    public void onRemoteSiteDarkFeatureEvent(ClusterEventWrapper wrappedEvent) {
        ClusterEvent event = wrappedEvent.getEvent();
        if (event instanceof SiteDarkFeatureEnabledEvent || event instanceof SiteDarkFeatureDisabledEvent) {
            this.isCdnFunctionalityAvailable.reset();
        }
    }
}

