/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.xsrf;

import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.confluence.dmz.struts.MappedAction;
import com.atlassian.confluence.impl.xsrf.StrutsXSRFConfig;
import com.atlassian.confluence.impl.xsrf.XsrfTokenValidationManager;
import com.atlassian.confluence.security.service.XsrfTokenService;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.struts.multipart.AtlassianJakartaMultiPartRequest;
import com.atlassian.struts.multipart.MultiPartUtil;
import com.atlassian.struts.xsrf.XsrfProtectionRequired;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload2.jakarta.servlet6.JakartaServletFileUpload;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultXsrfTokenValidationManager
implements XsrfTokenValidationManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultXsrfTokenValidationManager.class);
    public static final String SRC_MAIL_RECIPIENT = "src.mail.recipient";
    public static final String REQUIRE_TOKEN_PARAM_NAME = "RequireSecurityToken";
    private final XsrfTokenService tokenService;

    public DefaultXsrfTokenValidationManager(XsrfTokenService tokenService) {
        this.tokenService = tokenService;
    }

    @Override
    public boolean isRequestExempt(MappedAction mappedAction, HttpServletRequest request) {
        return mappedAction == null || this.isExemptedMailRequest(request) || this.isExemptedUploadRequest(request);
    }

    @Override
    public boolean isRequestValid(MappedAction mappedAction, HttpServletRequest request) {
        boolean isProtectionRequired = this.doesActionMethodRequireProtection(mappedAction.getActionParams().get(REQUIRE_TOKEN_PARAM_NAME), mappedAction.getActionMethod().getAnnotation(XsrfProtectionRequired.class), mappedAction.getActionMethod().getAnnotation(XsrfProtectionExcluded.class));
        if (isProtectionRequired && !this.tokenService.hasValidToken(request)) {
            LOG.debug("Invalid token provided for Action Class: {}, Method: {}", (Object)mappedAction.getActionClass().getSimpleName(), (Object)mappedAction.getActionMethod().getName());
            return false;
        }
        return true;
    }

    private boolean doesActionMethodRequireProtection(String requireTokenActionParam, XsrfProtectionRequired requiredAnnotation, XsrfProtectionExcluded excludedAnnotation) {
        if (requiredAnnotation != null) {
            return true;
        }
        if (excludedAnnotation != null) {
            return false;
        }
        if (requireTokenActionParam != null) {
            return Boolean.parseBoolean(requireTokenActionParam);
        }
        return StrutsXSRFConfig.getSecurityLevel().getDefaultProtection();
    }

    private boolean isExemptedMailRequest(HttpServletRequest request) {
        if (request.getAttribute("Plugin-Key") != null && StringUtils.isNotEmpty((CharSequence)request.getParameter("jwt"))) {
            String userKey = request.getParameter(SRC_MAIL_RECIPIENT);
            if (StringUtils.isBlank((CharSequence)userKey)) {
                return false;
            }
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            return user != null && user.getKey().getStringValue().equals(userKey);
        }
        return false;
    }

    private boolean isExemptedUploadRequest(HttpServletRequest request) {
        if (JakartaServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            AtlassianJakartaMultiPartRequest multiPartRequest = MultiPartUtil.unwrapMultiPartRequest((HttpServletRequest)request);
            return multiPartRequest != null && multiPartRequest.hasErrors();
        }
        return false;
    }
}

