/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport;

import java.util.Arrays;

public enum ExportScope {
    PAGE,
    SPACE,
    ALL,
    SITE;


    public String getString() {
        return this.name().toLowerCase();
    }

    public static ExportScope getScopeFromPropertyValue(String string) throws IllegalExportScopeException {
        return Arrays.stream(ExportScope.values()).filter(e -> e.name().equalsIgnoreCase(string)).findFirst().orElseThrow(() -> new IllegalExportScopeException(String.valueOf(string)));
    }

    public static class IllegalExportScopeException
    extends Exception {
        public IllegalExportScopeException(String providedString) {
            super("Inappropriate string value provided for exportScope: '" + providedString + "'. Expected page, space or all");
        }
    }
}

