/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.incrementalsync;

import com.atlassian.confluence.core.NotExportable;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserImpl;
import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.time.Instant;
import java.util.Objects;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Target;

@Entity
@Table(name="INCREMENTAL_SYNC_SUBSCRIPTION", indexes={@Index(name="sync_context_key_idx", columnList="subscription_context_key"), @Index(name="inc_sync_creator_idx", columnList="subscription_creator")})
@Cacheable(value=false)
@Access(value=AccessType.PROPERTY)
public class IncrementalSyncSubscriptionEntity
implements Serializable,
NotExportable {
    private static final long serialVersionUID = -7284939308866857069L;
    private long id;
    private ConfluenceUser subscriber;
    private String contextKey;
    private long mostRecentId;
    private String state;
    private String subscriptionData;
    private Instant lastAccessTime;

    @Id
    @Column(name="id")
    @GeneratedValue(generator="resettable-hilo-v5")
    @GenericGenerator(name="resettable-hilo-v5", strategy="com.atlassian.confluence.impl.hibernate.ResettableTableHiLoGeneratorV5")
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Column(name="subscription_context_key", length=150, nullable=false)
    public String getContextKey() {
        return this.contextKey;
    }

    public void setContextKey(String contextKey) {
        this.contextKey = contextKey;
    }

    @Column(name="subscription_most_recent_id", nullable=false)
    public long getMostRecentId() {
        return this.mostRecentId;
    }

    public void setMostRecentId(long mostRecentId) {
        this.mostRecentId = mostRecentId;
    }

    @Column(name="subscription_state", length=50, nullable=false)
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @Column(name="subscription_data", length=2047)
    public String getSubscriptionData() {
        return this.subscriptionData;
    }

    public void setSubscriptionData(String subscriptionData) {
        this.subscriptionData = subscriptionData;
    }

    @Column(name="subscription_last_access_time", nullable=false)
    public Instant getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(Instant lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(name="subscription_creator", foreignKey=@ForeignKey(name="FK_INC_SYNC_CREATOR"))
    @Target(value=ConfluenceUserImpl.class)
    public ConfluenceUser getSubscriber() {
        return this.subscriber;
    }

    public void setSubscriber(ConfluenceUser creator) {
        this.subscriber = creator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IncrementalSyncSubscriptionEntity)) {
            return false;
        }
        IncrementalSyncSubscriptionEntity that = (IncrementalSyncSubscriptionEntity)o;
        return this.id == that.id && this.mostRecentId == that.mostRecentId && Objects.equals(this.contextKey, that.contextKey) && Objects.equals(this.subscriber, that.subscriber) && Objects.equals(this.state, that.state) && Objects.equals(this.subscriptionData, that.subscriptionData) && Objects.equals(this.lastAccessTime, that.lastAccessTime);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.contextKey, this.subscriber, this.mostRecentId, this.state, this.subscriptionData, this.lastAccessTime);
    }
}

