/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.incrementalsync;

import com.atlassian.confluence.core.NotExportable;
import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.time.Instant;
import java.util.Objects;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="SPACE_INCLUSION", indexes={@Index(name="inclusion_space_key_idx", columnList="inclusion_space_key", unique=true)})
@Cacheable(value=false)
@Access(value=AccessType.PROPERTY)
public class SpaceInclusionEntity
implements Serializable,
NotExportable {
    private static final long serialVersionUID = 86233357316515192L;
    private long id;
    private String spaceKey;
    private boolean optInNewSpaces;
    private Instant creationTime;

    @Id
    @Column(name="id")
    @GeneratedValue(generator="resettable-hilo-v5")
    @GenericGenerator(name="resettable-hilo-v5", strategy="com.atlassian.confluence.impl.hibernate.ResettableTableHiLoGeneratorV5")
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Column(name="inclusion_space_key", length=255, nullable=false)
    public String getSpaceKey() {
        return this.spaceKey;
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    @Column(name="opt_in_new", nullable=false)
    public boolean isOptInNewSpaces() {
        return this.optInNewSpaces;
    }

    public void setOptInNewSpaces(boolean optInNewSpaces) {
        this.optInNewSpaces = optInNewSpaces;
    }

    @Column(name="inclusion_creation_time", nullable=false)
    public Instant getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Instant creationTime) {
        this.creationTime = creationTime;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SpaceInclusionEntity)) {
            return false;
        }
        SpaceInclusionEntity that = (SpaceInclusionEntity)o;
        return this.id == that.id && this.optInNewSpaces == that.optInNewSpaces && Objects.equals(this.spaceKey, that.spaceKey) && Objects.equals(this.creationTime, that.creationTime);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.spaceKey, this.optInNewSpaces, this.creationTime);
    }
}

