/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.accessmode;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.config.ConfigurationException;
import com.atlassian.confluence.api.model.accessmode.AccessMode;
import com.atlassian.confluence.impl.cluster.ClusterConfigurationHelperInternal;
import com.atlassian.confluence.internal.accessmode.AccessModeManager;
import com.atlassian.confluence.internal.accessmode.ThreadLocalReadOnlyAccessCacheInternal;
import java.util.Optional;

public class DefaultAccessModeManager
implements AccessModeManager {
    private final ApplicationConfiguration applicationConfig;
    private final ClusterConfigurationHelperInternal clusterConfigurationHelperInternal;

    public DefaultAccessModeManager(ApplicationConfiguration applicationConfig, ClusterConfigurationHelperInternal clusterConfigurationHelperInternal) {
        this.applicationConfig = applicationConfig;
        this.clusterConfigurationHelperInternal = clusterConfigurationHelperInternal;
    }

    @Override
    public AccessMode getAccessMode() {
        String accessModeName = (String)this.applicationConfig.getProperty((Object)"access.mode");
        return accessModeName != null ? AccessMode.valueOf((String)accessModeName) : AccessMode.READ_WRITE;
    }

    @Override
    public void updateAccessMode(AccessMode accessMode) throws ConfigurationException {
        Optional sharedAccessMode;
        this.applicationConfig.setProperty((Object)"access.mode", (Object)accessMode.name());
        this.applicationConfig.save();
        if (this.clusterConfigurationHelperInternal.isClusteredInstance() && ((sharedAccessMode = this.clusterConfigurationHelperInternal.getSharedProperty((Object)"access.mode")).isEmpty() || !sharedAccessMode.get().equals(accessMode.name()))) {
            this.clusterConfigurationHelperInternal.saveSharedProperty((Object)"access.mode", (Object)accessMode.name());
        }
    }

    @Override
    public boolean isReadOnlyAccessModeEnabled() {
        return this.getAccessMode().equals((Object)AccessMode.READ_ONLY);
    }

    @Override
    public boolean shouldEnforceReadOnlyAccess() {
        return !ThreadLocalReadOnlyAccessCacheInternal.hasReadOnlyAccessExemption() && this.isReadOnlyAccessModeEnabled();
    }
}

