/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.audit;

import com.atlassian.audit.entity.AuditAuthor;
import com.atlassian.audit.entity.AuditEntity;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.confluence.impl.audit.AffectedObjectEntity;
import com.atlassian.confluence.impl.audit.AuditRecordEntity;
import com.atlassian.confluence.impl.audit.ChangedValueEntity;
import com.atlassian.sal.api.user.UserKey;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class AuditFormatConverter {
    public static final String USER_TYPE = "user";
    public static final String UNKNOWN_AUDIT_METHOD = "Unknown";

    public AuditEntity toAuditEntity(AuditRecordEntity dbObject, CoverageArea defaultArea, CoverageLevel defaultLevel) {
        AuditEntity.Builder builder = AuditEntity.builder((AuditType)AuditType.fromI18nKeys((CoverageArea)defaultArea, (CoverageLevel)defaultLevel, (String)dbObject.getCategory(), (String)dbObject.getSummary()).withCategoryTranslation(dbObject.getCategory()).withActionTranslation(dbObject.getSummary()).build()).timestamp(dbObject.getCreationDate()).author(AuditAuthor.builder().type(USER_TYPE).id(Optional.ofNullable(dbObject.getAuthorKey()).map(UserKey::getStringValue).orElse("")).name(dbObject.getAuthorFullName()).build()).changedValues(dbObject.getChangedValues().stream().map(AuditFormatConverter::toNewChangedValue).collect(Collectors.toList())).source(dbObject.getRemoteAddress()).method(UNKNOWN_AUDIT_METHOD);
        return builder.affectedObjects(AuditFormatConverter.createAffectedObjectsList(dbObject)).build();
    }

    private static List<AuditResource> createAffectedObjectsList(AuditRecordEntity dbObject) {
        if (StringUtils.isNotBlank((CharSequence)dbObject.getObjectName()) && StringUtils.isNotBlank((CharSequence)dbObject.getObjectType())) {
            Stream<AuditResource> firstAffectedObject = Stream.of(AuditResource.builder((String)dbObject.getObjectName(), (String)dbObject.getObjectType()).build());
            Stream<AuditResource> associatedObjects = dbObject.getAssociatedObjects().stream().map(AuditFormatConverter::toNewAuditResource);
            return Stream.concat(firstAffectedObject, associatedObjects).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static AuditResource toNewAuditResource(AffectedObjectEntity dbObject) {
        return AuditResource.builder((String)Optional.ofNullable(dbObject.getName()).orElse(""), (String)dbObject.getType()).build();
    }

    public static ChangedValue toNewChangedValue(ChangedValueEntity dbObject) {
        return ChangedValue.fromI18nKeys((String)dbObject.getName()).withKeyTranslation(dbObject.getName()).from(dbObject.getOldValue()).to(dbObject.getNewValue()).build();
    }
}

