/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.audit.persistence.dao.hibernate;

import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.PageResponseImpl;
import com.atlassian.confluence.core.persistence.hibernate.HibernateObjectDao;
import com.atlassian.confluence.impl.audit.AuditRecordEntity;
import com.atlassian.confluence.impl.audit.AuditSearchUtils;
import com.atlassian.confluence.internal.audit.persistence.dao.AuditRecordDao;
import com.atlassian.core.exception.InfrastructureException;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.query.Query;

@Deprecated
public class HibernateAuditRecordDao
extends HibernateObjectDao
implements AuditRecordDao {
    @Override
    public void storeRecord(AuditRecordEntity auditRecordEntity) {
        if (auditRecordEntity.getCreationDate().isAfter(Instant.now())) {
            throw new IllegalArgumentException("AuditRecordEntity creation date cannot be in the future");
        }
        this.hibernate().save(auditRecordEntity);
    }

    @Override
    public PageResponse<AuditRecordEntity> getRecords(LimitedRequest request, Instant startDate, Instant endDate, boolean includeSysAdmin, String searchString) {
        List<AuditRecordEntity> results = this.getRecordsInternal(request.getStart(), request.getLimit() + 1, startDate, endDate, includeSysAdmin, searchString);
        return PageResponseImpl.filteredResponse((LimitedRequest)request, results, (java.util.function.Predicate)Predicates.alwaysTrue());
    }

    @Override
    public List<Long> fetchAllRecordIds() {
        return this.hibernate().execute(session -> {
            Query query = session.createNamedQuery("confluence.auditRecord_fetchAllIds", Long.class);
            query.setCacheable(false);
            return query.list();
        });
    }

    @Override
    public List<AuditRecordEntity> fetchByIds(List<Long> ids) {
        return this.hibernate().execute(session -> {
            Query query = session.createNamedQuery("confluence.auditRecord_fetchByIds", AuditRecordEntity.class);
            query.setCacheable(false);
            query.setParameterList("ids", (Collection)ids);
            return query.list();
        });
    }

    @Override
    public void deleteRecords(Collection<AuditRecordEntity> recordEntities) {
        recordEntities.forEach(this::remove);
    }

    @Override
    public void cleanOldRecords(Instant before) {
        int batch_size = 1000;
        boolean has_more = true;
        while (has_more) {
            List<AuditRecordEntity> results = this.getRecordsInternal(0, 1000, Instant.EPOCH, before, true, "");
            has_more = results.size() >= 1000;
            results.stream().forEach(this::remove);
        }
    }

    private List<AuditRecordEntity> getRecordsInternal(int start, int limit, Instant startDate, Instant endDate, boolean includeSysAdmin, String searchString) {
        return this.hibernate().execute(session -> {
            Query<AuditRecordEntity> query = HibernateAuditRecordDao.getRecordsQuery(session, startDate, endDate, includeSysAdmin, searchString);
            if (start > 0) {
                query.setFirstResult(start);
            }
            if (limit > 0) {
                query.setMaxResults(limit);
            }
            HibernateAuditRecordDao.applyTransactionTimeout(query, this.getSessionFactory());
            return query.list();
        });
    }

    private static Query<AuditRecordEntity> getRecordsQuery(Session session, Instant startDate, Instant endDate, boolean includeSysAdmin, String searchString) {
        ImmutableSet<String> tokens;
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(AuditRecordEntity.class);
        Root root = criteria.from(AuditRecordEntity.class);
        ArrayList<Predicate> clauses = new ArrayList<Predicate>();
        clauses.add(builder.between((Expression)root.get("creationDate"), (Comparable)startDate, (Comparable)endDate));
        if (!includeSysAdmin) {
            clauses.add(builder.equal((Expression)root.get("sysAdmin"), (Object)false));
        }
        if (!(tokens = AuditSearchUtils.tokenize(searchString)).isEmpty()) {
            ArrayList or = new ArrayList();
            tokens.stream().forEach(token -> or.add(builder.like((Expression)root.get("searchString"), "%" + token + "%")));
            clauses.add(builder.or((Predicate[])or.toArray(Predicate[]::new)));
        }
        criteria.where((Predicate[])clauses.toArray(Predicate[]::new));
        criteria.orderBy(new Order[]{builder.desc((Expression)root.get("creationDate"))});
        return session.createQuery(criteria);
    }

    private void remove(AuditRecordEntity objectToRemove) {
        try {
            this.hibernate().delete(objectToRemove);
        }
        catch (Exception e) {
            throw new InfrastructureException((Throwable)e);
        }
    }

    public Class getPersistentClass() {
        return AuditRecordEntity.class;
    }
}

