/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.content.bodycontentquerier;

import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.core.BodyContent;
import com.atlassian.confluence.core.persistence.schema.api.SchemaInformationService;
import com.atlassian.confluence.impl.hibernate.query.InExpressionBuilder;
import com.atlassian.confluence.internal.content.bodycontentquerier.ContentQuerier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.dialect.Dialect;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BodyContentQuerier
implements ContentQuerier {
    private final Logger logger = LoggerFactory.getLogger(BodyContentQuerier.class);
    private final SessionFactory sessionFactory;
    private final SchemaInformationService dbSchemaInformationService;

    BodyContentQuerier(SessionFactory sessionFactory, SchemaInformationService dbSchemaInformationService) {
        this.sessionFactory = sessionFactory;
        this.dbSchemaInformationService = dbSchemaInformationService;
    }

    @Override
    public Map<Long, BodyContent> getBodyByContentIds(List<ContentId> contentIds) {
        List<Long> ids = contentIds.stream().map(ContentId::asLong).toList();
        InExpressionBuilder inExpressionBuilder = InExpressionBuilder.getInExpressionBuilderDefaultLimit((String)"contentId", (String)"contentIds", new ArrayList(), (Dialect)this.dbSchemaInformationService.getDialect());
        return this.executeQuery("FROM BodyContent WHERE " + inExpressionBuilder.convertIdsToInClauseString(ids));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, BodyContent> executeQuery(String sql) {
        Session session = this.sessionFactory.openSession();
        Transaction transaction = null;
        Map results = null;
        try {
            transaction = session.beginTransaction();
            Query query = session.createQuery(sql, BodyContent.class);
            query.setReadOnly(true);
            results = query.getResultStream().collect(Collectors.toMap(body -> ((BodyContent)body).getContent().getContentId().asLong(), Function.identity()));
            transaction.commit();
        }
        catch (RuntimeException e) {
            if (transaction != null) {
                transaction.rollback();
            }
            this.logger.error("Error executing query: {}", (Object)e.getMessage());
        }
        finally {
            session.close();
        }
        return results;
    }
}

