/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.content.collab;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.xhtml.api.XhtmlVisitor;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentMacroVisitor
implements XhtmlVisitor {
    private static final Logger log = LoggerFactory.getLogger(AttachmentMacroVisitor.class);
    private boolean macroOrImageStarted;
    private boolean attachmentLinked;
    private boolean contentLinked;
    private final List<Attachment> attachments;
    private final ContentEntityObject contentEntityObject;
    private final ContentEntityObject parentCeo;

    public AttachmentMacroVisitor(List<Attachment> attachments, ContentEntityObject contentEntityObject, ContentEntityObject parentCeo) {
        this.attachments = attachments;
        this.contentEntityObject = contentEntityObject;
        this.parentCeo = parentCeo;
        this.macroOrImageStarted = false;
        this.attachmentLinked = false;
        this.contentLinked = false;
    }

    private boolean isAttachmentLinked(StartElement startElement) {
        Attribute attribute = startElement.getAttributeByName(new QName("http://atlassian.com/resource/identifier", "filename", "ri"));
        String filename = attribute != null ? attribute.getValue() : null;
        log.debug("Filename for the attachment is {}", (Object)filename);
        return filename != null && this.attachments.stream().anyMatch(attachment -> attachment.getFileName().equalsIgnoreCase(filename));
    }

    private boolean isContentLinked(StartElement startElement, ContentEntityObject parentCeo) {
        Attribute attribute = startElement.getAttributeByName(new QName("http://atlassian.com/resource/identifier", "content-title", "ri"));
        String contentTitle = attribute != null ? attribute.getValue() : null;
        log.debug("Content Title for the attachment is {}", (Object)contentTitle);
        return parentCeo.getLowerTitle().equalsIgnoreCase(contentTitle);
    }

    @Override
    public boolean handle(XMLEvent xmlEvent, ConversionContext context) {
        EndElement endElement;
        String elementName;
        if (xmlEvent.isStartElement()) {
            String elementName2;
            StartElement startElement = xmlEvent.asStartElement();
            switch (elementName2 = startElement.getName().getLocalPart()) {
                case "structured-macro": 
                case "image": {
                    this.macroOrImageStarted = true;
                    break;
                }
                case "attachment": {
                    this.attachmentLinked = this.isAttachmentLinked(startElement) || this.attachmentLinked;
                    break;
                }
                case "page": {
                    this.contentLinked = this.isContentLinked(startElement, this.parentCeo) || this.contentLinked;
                    break;
                }
            }
            if (this.macroOrImageStarted && this.attachmentLinked && this.contentLinked) {
                log.debug("Attachment macro found linked to the content {}", (Object)this.contentEntityObject.getContentId());
                return false;
            }
        } else if (xmlEvent.isEndElement() && ((elementName = (endElement = xmlEvent.asEndElement()).getName().getLocalPart()).equalsIgnoreCase("structured-macro") || elementName.equalsIgnoreCase("image"))) {
            this.macroOrImageStarted = false;
            this.contentLinked = false;
            this.attachmentLinked = false;
        }
        return true;
    }

    public boolean isMacroStarted() {
        return this.macroOrImageStarted;
    }

    public boolean isAttachmentLinked() {
        return this.attachmentLinked;
    }

    public boolean isContentLinked() {
        return this.contentLinked;
    }
}

