/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.content.collab;

import com.atlassian.confluence.api.service.content.util.ReconcileContentAsyncFlag;
import com.atlassian.confluence.event.events.content.page.synchrony.AsyncContentUpdatedEvent;
import com.atlassian.confluence.event.events.content.page.synchrony.ContentUpdatedEvent;
import com.atlassian.confluence.internal.content.collab.ReconcileContentRegisterTask;
import com.atlassian.event.api.EventPublisher;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconcileContentTask
implements ReconcileContentRegisterTask<ContentUpdatedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(ReconcileContentTask.class);
    private final Set<ContentUpdatedEvent> contentToReconcileEvents;
    private final EventPublisher eventPublisher;

    public ReconcileContentTask(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        this.contentToReconcileEvents = new HashSet<ContentUpdatedEvent>();
    }

    @Override
    public void run() {
        logger.info("Processing {} content updated reconciliation events", (Object)this.contentToReconcileEvents.size());
        for (ContentUpdatedEvent contentUpdatedEvent : this.contentToReconcileEvents) {
            this.eventPublisher.publish((Object)(ReconcileContentAsyncFlag.isAsync() ? AsyncContentUpdatedEvent.from(contentUpdatedEvent) : contentUpdatedEvent));
        }
        logger.info("{} {} content updated reconciliation events", (Object)(ReconcileContentAsyncFlag.isAsync() ? "Published" : "Processed"), (Object)this.contentToReconcileEvents.size());
    }

    @Override
    public void registerReconcileContent(ContentUpdatedEvent contentUpdatedEvent) {
        if (contentUpdatedEvent == null) {
            return;
        }
        this.contentToReconcileEvents.add(contentUpdatedEvent);
    }
}

