/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.content.collab;

import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.LimitedRequestImpl;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.BodyContent;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.dmz.ContentEntityManagerInternal;
import com.atlassian.confluence.internal.content.bodycontentquerier.BodyContentQuerier;
import com.atlassian.confluence.internal.content.collab.AttachmentMacroVisitor;
import com.atlassian.confluence.internal.content.collab.AttachmentRelatedContentReconciliationListener;
import com.atlassian.confluence.internal.content.collab.ContentReconciliationManager;
import com.atlassian.confluence.internal.content.collab.OwningContent;
import com.atlassian.confluence.internal.content.collab.ReconcileContentRegisterTask;
import com.atlassian.confluence.internal.content.collab.ReconciliationExecutorService;
import com.atlassian.confluence.internal.persistence.ContentEntityObjectDaoInternal;
import com.atlassian.confluence.links.LinkManager;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class ReconcileReferringContentTask
implements ReconcileContentRegisterTask<OwningContent> {
    private static Logger logger = LoggerFactory.getLogger(ReconcileReferringContentTask.class);
    private final PlatformTransactionManager transactionManager;
    private final ContentEntityManagerInternal contentEntityManager;
    private final ContentReconciliationManager reconciliationManager;
    private final LinkManager linkManager;
    private final ContentEntityObjectDaoInternal contentEntityObjectDao;
    private final Set<Long> attachmentOwningContents;
    private final List<Attachment> attachments;
    private final HashMap<Long, Boolean> shouldIncludeOwnContentMap;
    private ConfluenceUser currentUser;
    private final BodyContentQuerier bodyContentQuerier;
    private final XhtmlContent xhtmlContent;
    private final ReconciliationExecutorService reconciliationExecutorService;
    private static int processingBatchSize = Integer.getInteger("reconcile.referring.content.batch.size", 20);

    public ReconcileReferringContentTask(PlatformTransactionManager transactionManager, ContentEntityManagerInternal contentEntityManager, ContentReconciliationManager reconciliationManager, ContentEntityObjectDaoInternal contentEntityObjectDao, LinkManager linkManager, BodyContentQuerier bodyContentQuerier, XhtmlContent xhtmlContent, ReconciliationExecutorService reconciliationExecutorService) {
        this.transactionManager = transactionManager;
        this.contentEntityManager = contentEntityManager;
        this.reconciliationManager = reconciliationManager;
        this.contentEntityObjectDao = contentEntityObjectDao;
        this.linkManager = linkManager;
        this.attachmentOwningContents = new HashSet<Long>();
        this.shouldIncludeOwnContentMap = new HashMap();
        this.attachments = new ArrayList<Attachment>();
        this.bodyContentQuerier = bodyContentQuerier;
        this.xhtmlContent = xhtmlContent;
        this.reconciliationExecutorService = reconciliationExecutorService;
    }

    @Override
    public void run() {
        CompletableFuture.runAsync(this::runAsync, this.reconciliationExecutorService.getExecutorService());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runAsync() {
        AuthenticatedUserThreadLocal.set(this.currentUser);
        AtomicInteger batchNumber = new AtomicInteger(0);
        HashSet uniqueReferringContents = new HashSet();
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        transactionTemplate.setPropagationBehavior(3);
        transactionTemplate.setReadOnly(true);
        try {
            transactionTemplate.execute(status -> {
                this.ofSubLists(new ArrayList<Long>(this.attachmentOwningContents), processingBatchSize).forEach(batchContents -> {
                    logger.info("Process owning content for batch number {}", (Object)batchNumber.incrementAndGet());
                    logger.debug("Processing a batch of owning content: {}", batchContents);
                    List<ContentId> contentIdList = batchContents.stream().map(ContentId::of).collect(Collectors.toList());
                    PageResponse<ContentEntityObject> response = this.contentEntityManager.getByIdsAndFilters(contentIdList, LimitedRequestImpl.create((int)batchContents.size()), contentEntityObject -> true);
                    List owningCEOList = response.getResults();
                    if (owningCEOList == null || owningCEOList.isEmpty()) {
                        logger.debug("Could not load owning content from DB --> Skip this batch");
                    }
                    logger.debug("There are [{}] of owning CEO is loaded from DB", (Object)owningCEOList.size());
                    List spaceContentEntityObjectList = owningCEOList.stream().filter(contentEntityObject -> contentEntityObject instanceof SpaceContentEntityObject).map(contentEntityObject -> (SpaceContentEntityObject)contentEntityObject).collect(Collectors.toList());
                    Map<String, List<SpaceContentEntityObject>> groupCEOBySpaceKey = spaceContentEntityObjectList.stream().collect(Collectors.groupingBy(SpaceContentEntityObject::getSpaceKey));
                    logger.debug("Space detail in current batch: {}", groupCEOBySpaceKey.keySet());
                    groupCEOBySpaceKey.entrySet().stream().forEach(contentIdListGroupBySpace -> {
                        List<ContentEntityObject> tempCEOList = ((List)contentIdListGroupBySpace.getValue()).stream().map(item -> item).collect(Collectors.toList());
                        Collection<ContentEntityObject> referringContents = this.linkManager.getReferringContent((String)contentIdListGroupBySpace.getKey(), tempCEOList);
                        uniqueReferringContents.addAll(referringContents);
                    });
                    logger.info("Finishing process for owning content batch {}", (Object)batchNumber.get());
                });
                return null;
            });
            if (this.attachmentOwningContents.isEmpty()) {
                logger.info("No attachment owning content found, not triggering reconciliation");
                return;
            }
            ContentEntityObject parentCeo = this.contentEntityManager.getById(ContentId.of((long)((Long)this.attachmentOwningContents.stream().toList().get(0))));
            logger.debug("There are {} distinct CEO to potentially reconcile", (Object)uniqueReferringContents.size());
            transactionTemplate.setReadOnly(false);
            this.ofSubLists(new ArrayList(uniqueReferringContents), processingBatchSize).forEach(batchContents -> {
                logger.info("Process reconcile content for batch number {}", (Object)batchNumber.incrementAndGet());
                logger.debug("Processing a batch of reconcile content: {}", batchContents);
                try {
                    List<ContentEntityObject> filteredContent = batchContents.stream().filter(Objects::nonNull).filter(reconcileContent -> this.getShouldIncludeOwnContent(reconcileContent.getId()) || !this.attachmentOwningContents.contains(reconcileContent.getId())).filter(ContentEntityObject::isCurrent).toList();
                    List<ContentId> batchContentList = filteredContent.stream().map(ContentEntityObject::getContentId).toList();
                    Map<Long, BodyContent> batchBodyContents = this.bodyContentQuerier.getBodyByContentIds(batchContentList);
                    transactionTemplate.execute(reconciliationStatus -> {
                        filteredContent.stream().filter(reconcileContent -> this.isContentLinkedToAttachment((ContentEntityObject)reconcileContent, parentCeo, batchBodyContents)).forEach(reconcileContent -> {
                            ContentEntityObject reconcileContentTemp = this.contentEntityManager.getById(reconcileContent.getContentId());
                            AttachmentRelatedContentReconciliationListener.updateCEOWithAttachmentChange(reconcileContentTemp, this.contentEntityObjectDao);
                            this.reconciliationManager.handleEditorOnlyContentUpdateBeforeSave(reconcileContentTemp, null);
                            this.reconciliationManager.handleEditorOnlyContentUpdateAfterSave(reconcileContentTemp, null, Optional.ofNullable(reconcileContentTemp.getLastModificationDate()));
                            logger.debug("Reconcile for content {} is done", (Object)reconcileContentTemp.getContentId());
                        });
                        return null;
                    });
                }
                catch (Exception e) {
                    logger.error("Error occurred while processing reconcile content", (Throwable)e);
                }
                logger.info("Finishing process for reconcile content batch {}", (Object)batchNumber.get());
            });
        }
        finally {
            AuthenticatedUserThreadLocal.reset();
        }
    }

    boolean isContentLinkedToAttachment(@NonNull ContentEntityObject contentEntityObject, ContentEntityObject parentCeo, Map<Long, BodyContent> bodyContentMap) {
        if (bodyContentMap != null && bodyContentMap.containsKey(contentEntityObject.getContentId().asLong())) {
            BodyContent bodyContent = bodyContentMap.get(contentEntityObject.getContentId().asLong());
            AttachmentMacroVisitor attachmentMacroVisitor = new AttachmentMacroVisitor(this.attachments, contentEntityObject, parentCeo);
            try {
                this.xhtmlContent.handleXhtmlElements(bodyContent.getBody(), new DefaultConversionContext(new PageContext(contentEntityObject)), Collections.singletonList(attachmentMacroVisitor));
            }
            catch (XhtmlException e) {
                logger.error("Error occurred while parsing the body content", (Throwable)e);
            }
            return attachmentMacroVisitor.isAttachmentLinked() && attachmentMacroVisitor.isContentLinked() && attachmentMacroVisitor.isMacroStarted();
        }
        return false;
    }

    @Override
    public void registerReconcileContent(OwningContent owningContent) {
        Boolean isPreviousIncluding;
        if (owningContent == null) {
            return;
        }
        long contentId = owningContent.getContentId();
        boolean shouldIncludeOwnContent = owningContent.isShouldIncludeOwnContent();
        if (contentId <= 0L) {
            logger.warn("Content with ID [{}] is not valid. So we cannot register it for reconcile", (Object)contentId);
            return;
        }
        this.attachmentOwningContents.add(contentId);
        if (owningContent.getAttachments() != null) {
            this.attachments.addAll(owningContent.getAttachments());
        }
        if ((isPreviousIncluding = this.shouldIncludeOwnContentMap.get(contentId)) != null && isPreviousIncluding.booleanValue()) {
            logger.debug("Skip register reconcile content because it is already include own content");
            return;
        }
        this.currentUser = AuthenticatedUserThreadLocal.get();
        this.shouldIncludeOwnContentMap.put(contentId, shouldIncludeOwnContent);
    }

    private boolean getShouldIncludeOwnContent(long contentId) {
        Boolean result = this.shouldIncludeOwnContentMap.get(contentId);
        if (result == null) {
            logger.warn("Could not find shouldIncludeOwnContentMap for Content ID {} but will reconcile anyway", (Object)contentId);
            return false;
        }
        if (result.booleanValue()) {
            logger.debug("It is {} to include content {} as it is a owning content", (Object)result, (Object)contentId);
        }
        return result;
    }

    private <T> Stream<List<T>> ofSubLists(List<T> source, int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("length = " + length);
        }
        int size = source.size();
        if (size == 0) {
            return Stream.empty();
        }
        int fullChunks = (size - 1) / length;
        return IntStream.range(0, fullChunks + 1).mapToObj(n -> source.subList(n * length, n == fullChunks ? size : (n + 1) * length));
    }
}

