/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.content.collab;

import com.atlassian.confluence.internal.content.collab.ReconciliationRejectedExecutionHandler;
import io.atlassian.util.concurrent.ThreadFactories;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class ReconciliationExecutorService
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(ReconciliationExecutorService.class);
    private ExecutorService executorService = new ThreadPoolExecutor(DEFAULT_CORE_POOL_SIZE, DEFAULT_MAX_POOL_SIZE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), ReconciliationExecutorService.getThreadFactory("reconciliation-executor"), new ReconciliationRejectedExecutionHandler());
    private static final int DEFAULT_CORE_POOL_SIZE = Integer.getInteger("confluence.reconciliation.executor.core.pool.size", 0);
    private static final int DEFAULT_MAX_POOL_SIZE = Integer.getInteger("confluence.reconciliation.executor.max.pool.size", 10);

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void destroy() throws Exception {
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException ie) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private static ThreadFactory getThreadFactory(String threadNamePrefix) {
        return ThreadFactories.named((String)threadNamePrefix).type(ThreadFactories.Type.DAEMON).uncaughtExceptionHandler((t, e) -> {
            log.warn("{}", (Object)e.getMessage());
            log.debug("Detailed stack trace: ", e);
        }).build();
    }
}

