/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.diagnostics;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.internal.diagnostics.HttpRequestMonitor;
import com.atlassian.confluence.util.MemoizingComponentReference;
import com.atlassian.spring.container.ContainerManager;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Supplier;

@UnrestrictedAccess
public class HttpRequestMonitoringFilter
extends HttpFilter {
    private static final boolean HTTP_SLOW_REQUEST_DISABLE = Boolean.getBoolean("diagnostics.http.slow.request.disable");
    private final Supplier<HttpRequestMonitor> monitorReference = MemoizingComponentReference.containerComponent("httpRequestMonitor");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(HttpServletRequest servletRequest, HttpServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!ContainerManager.isContainerSetup() || HTTP_SLOW_REQUEST_DISABLE) {
            filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
            return;
        }
        Optional<HttpRequestMonitor> monitor = Optional.ofNullable(this.monitorReference.get());
        try {
            monitor.ifPresent(mon -> mon.start(servletRequest));
            filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
        }
        finally {
            monitor.ifPresent(mon -> mon.stop(servletRequest));
        }
    }

    public void destroy() {
    }
}

