/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.diagnostics.persistence.dao.hibernate;

import com.atlassian.diagnostics.Alert;
import com.atlassian.diagnostics.AlertTrigger;
import com.atlassian.diagnostics.Issue;
import com.atlassian.diagnostics.Severity;
import com.atlassian.diagnostics.internal.dao.AlertEntity;
import com.google.common.base.MoreObjects;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.Table;
import java.time.Instant;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="DIAGNOSTICS_ALERTS", indexes={@Index(name="al_is_comp_id_idx", columnList="ISSUE_COMPONENT_ID"), @Index(name="al_issue_id_idx", columnList="ISSUE_ID"), @Index(name="al_issue_severity_idx", columnList="ISSUE_SEVERITY"), @Index(name="al_node_name_lower_idx", columnList="NODE_NAME_LOWER"), @Index(name="al_timetamp_idx", columnList="TIMESTAMP"), @Index(name="al_trigger_plug_key_lower_idx", columnList="TRIGGER_PLUGIN_KEY_LOWER")})
@BatchSize(size=100)
@Immutable
@Proxy(lazy=false)
public class AlertEntityImpl
implements AlertEntity {
    private static final Logger log = LoggerFactory.getLogger(AlertEntityImpl.class);
    @Id
    @GeneratedValue(generator="resettable-hilo-v5")
    @GenericGenerator(name="resettable-hilo-v5", strategy="com.atlassian.confluence.impl.hibernate.ResettableTableHiLoGeneratorV5")
    @Column(name="id", updatable=false)
    private long id;
    @Column(name="DETAILS_JSON", updatable=false)
    @Type(type="com.atlassian.confluence.core.persistence.hibernate.CustomClobType")
    private String detailsJson;
    @Column(name="ISSUE_COMPONENT_ID", nullable=false, updatable=false, length=255)
    private String issueComponentId;
    @Column(name="ISSUE_ID", nullable=false, updatable=false, length=255)
    private String issueId;
    @Column(name="ISSUE_SEVERITY", nullable=false, updatable=false)
    private int issueSeverityId;
    @Column(name="NODE_NAME", nullable=false, updatable=false, length=255)
    private String nodeName;
    @Column(name="NODE_NAME_LOWER", nullable=false, updatable=false, length=255)
    private String nodeNameLower;
    @Column(name="TIMESTAMP", nullable=false, updatable=false)
    private long timestampUtc;
    @Column(name="TRIGGER_MODULE", updatable=false, length=255)
    private String triggerModule;
    @Column(name="TRIGGER_PLUGIN_KEY", updatable=false, length=255)
    private String triggerPluginKey;
    @Column(name="TRIGGER_PLUGIN_KEY_LOWER", updatable=false, length=255)
    private String triggerPluginKeyLower;
    @Column(name="TRIGGER_PLUGIN_VERSION", updatable=false, length=255)
    private String triggerPluginVersion;

    protected AlertEntityImpl() {
    }

    public AlertEntityImpl(Alert alert) {
        Issue issue = Objects.requireNonNull(alert, "alert").getIssue();
        AlertTrigger trigger = alert.getTrigger();
        this.detailsJson = alert.getDetails().map(details -> this.generateJson(details, issue)).orElse(null);
        this.id = 0L;
        this.issueComponentId = Objects.requireNonNull(StringUtils.trimToNull((String)Objects.requireNonNull(issue.getComponent(), "issueComponent").getId()), "issueComponentId");
        this.issueId = Objects.requireNonNull(StringUtils.trimToNull((String)issue.getId()), "issueId");
        this.issueSeverityId = Objects.requireNonNull(issue.getSeverity(), "issueSeverity").getId();
        this.nodeName = Objects.requireNonNull(StringUtils.trimToNull((String)alert.getNodeName()), "nodeName");
        this.nodeNameLower = StringUtils.lowerCase((String)this.nodeName, (Locale)Locale.ROOT);
        this.timestampUtc = Objects.requireNonNull(alert.getTimestamp(), "timestamp").toEpochMilli();
        this.triggerModule = trigger.getModule().map(StringUtils::trimToNull).orElse(null);
        this.triggerPluginKey = (String)MoreObjects.firstNonNull((Object)StringUtils.trimToNull((String)trigger.getPluginKey()), (Object)"not-detected");
        this.triggerPluginKeyLower = this.triggerPluginKey.toLowerCase(Locale.ROOT);
        this.triggerPluginVersion = trigger.getPluginVersion().map(StringUtils::trimToNull).orElse(null);
    }

    public @Nullable String getDetailsJson() {
        return this.detailsJson;
    }

    public long getId() {
        return this.id;
    }

    public @NonNull String getIssueId() {
        return this.issueId;
    }

    public @NonNull String getIssueComponentId() {
        return this.issueComponentId;
    }

    public @NonNull Severity getIssueSeverity() {
        return Severity.fromId((int)this.issueSeverityId);
    }

    protected int getIssueSeverityId() {
        return this.issueSeverityId;
    }

    public @NonNull String getNodeName() {
        return this.nodeName;
    }

    public @Nullable String getTriggerModule() {
        return this.triggerModule;
    }

    public @NonNull String getTriggerPluginKey() {
        return this.triggerPluginKey;
    }

    public @Nullable String getTriggerPluginVersion() {
        return this.triggerPluginVersion;
    }

    public @NonNull Instant getTimestamp() {
        return Instant.ofEpochMilli(this.timestampUtc);
    }

    private String generateJson(Object details, Issue issue) {
        try {
            return Optional.ofNullable(details).map(d -> issue.getJsonMapper().toJson(d)).map(StringUtils::stripToNull).orElse(null);
        }
        catch (Exception e) {
            log.warn("Failed to store as JSON the details of an alert for issue {}", (Object)issue.getId());
            return null;
        }
    }

    private String getNodeNameLower() {
        return this.nodeNameLower;
    }

    private long getTimestampUtc() {
        return this.timestampUtc;
    }

    private String getTriggerPluginKeyLower() {
        return this.triggerPluginKeyLower;
    }

    private void setDetailsJson(String detailsJson) {
        this.detailsJson = detailsJson;
    }

    private void setId(long id) {
        this.id = id;
    }

    private void setIssueId(String issueId) {
        this.issueId = issueId;
    }

    private void setIssueComponentId(String issueComponentId) {
        this.issueComponentId = issueComponentId;
    }

    private void setIssueSeverityId(int issueSeverityId) {
        this.issueSeverityId = issueSeverityId;
    }

    private void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    private void setNodeNameLower(String nodeNameLower) {
        this.nodeNameLower = nodeNameLower;
    }

    private void setTriggerModule(String triggerModule) {
        this.triggerModule = triggerModule;
    }

    private void setTriggerPluginKey(String triggerPluginKey) {
        this.triggerPluginKey = triggerPluginKey;
    }

    private void setTriggerPluginKeyLower(String triggerPluginKeyLower) {
        this.triggerPluginKeyLower = triggerPluginKeyLower;
    }

    private void setTriggerPluginVersion(String triggerPluginVersion) {
        this.triggerPluginVersion = triggerPluginVersion;
    }

    private void setTimestampUtc(long timestamp) {
        this.timestampUtc = timestamp;
    }
}

