/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.index;

import bucket.core.persistence.hibernate.HibernateHandle;
import com.atlassian.confluence.api.model.journal.JournalIdentifier;
import com.atlassian.confluence.api.service.journal.JournalService;
import com.atlassian.confluence.core.persistence.SearchableDao;
import com.atlassian.confluence.impl.journal.JournalEntry;
import com.atlassian.confluence.impl.journal.JournalManager;
import com.atlassian.confluence.index.ReIndexSpec;
import com.atlassian.confluence.internal.index.BatchIndexer;
import com.atlassian.confluence.internal.index.BatchIndexerFactory;
import com.atlassian.confluence.internal.index.EventPublishingReindexProgress;
import com.atlassian.confluence.internal.index.Index;
import com.atlassian.confluence.internal.index.ReindexProgress;
import com.atlassian.confluence.internal.index.Reindexer;
import com.atlassian.confluence.search.ReIndexOption;
import com.atlassian.confluence.search.v2.BatchUpdateAction;
import com.atlassian.confluence.search.v2.SearchFieldMappings;
import com.atlassian.confluence.search.v2.SearchIndexAccessException;
import com.atlassian.confluence.search.v2.SearchIndexAccessor;
import com.atlassian.confluence.search.v2.SearchIndexAction;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.util.Progress;
import com.atlassian.event.api.EventPublisher;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReindexer
implements Reindexer {
    protected static final Set<Index> INDEXES_TO_SET_EARLIEST_ENTRY = EnumSet.of(Index.MAIN_INDEX, Index.EDGE_INDEX, Index.CHANGE_INDEX);
    public static final Set<Index> INDEXES_TO_SNAPSHOT = EnumSet.of(Index.MAIN_INDEX, Index.CHANGE_INDEX);
    public static final String KEY_REINDEX_PARTITION_SIZE_MAX = "reindex.partition.size.max";
    public static final int DEFAULT_REINDEX_PARTITION_SIZE_MAX = 100000;
    private static final Logger log = LoggerFactory.getLogger(AbstractReindexer.class);
    protected final SearchIndexAccessor contentIndexAccessor;
    protected final SearchIndexAccessor changeIndexAccessor;
    protected final SearchableDao searchableDao;
    protected final EventPublisher eventPublisher;
    protected final BatchIndexerFactory batchIndexerFactory;
    protected final JournalManager journalManager;
    protected final JournalService journalService;

    public AbstractReindexer(SearchableDao searchableDao, SearchIndexAccessor contentIndexAccessor, SearchIndexAccessor changeIndexAccessor, EventPublisher eventPublisher, BatchIndexerFactory batchIndexerFactory, JournalManager journalManager, JournalService journalService) {
        this.searchableDao = Objects.requireNonNull(searchableDao);
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
        this.contentIndexAccessor = Objects.requireNonNull(contentIndexAccessor);
        this.changeIndexAccessor = Objects.requireNonNull(changeIndexAccessor);
        this.batchIndexerFactory = Objects.requireNonNull(batchIndexerFactory);
        this.journalManager = Objects.requireNonNull(journalManager);
        this.journalService = Objects.requireNonNull(journalService);
    }

    @Override
    public void reIndex(EnumSet<ReIndexOption> maybeOptions, Progress progress) {
        this.reIndex(maybeOptions, new Context(this, progress));
    }

    protected void reIndex(EnumSet<ReIndexOption> maybeOptions, Context ctx) {
        ctx.progress.reindexStarted(maybeOptions, Collections.emptyList());
        EnumSet<ReIndexOption> options = maybeOptions == null ? ReIndexOption.fullReindex() : maybeOptions;
        try {
            options.forEach(option -> {
                ctx.progress.reindexStageStarted((ReIndexOption)option);
                this.reIndex((ReIndexOption)option, ctx);
                ctx.progress.reindexStageFinished((ReIndexOption)option);
            });
            ctx.reindexFinished(Collections.emptyList(), maybeOptions);
        }
        catch (Exception e) {
            log.error("Reindex failed", (Throwable)e);
            ctx.progress.reIndexFailed();
        }
    }

    @Override
    public void reIndex(EnumSet<ReIndexOption> maybeOptions, @NonNull SearchQuery searchQuery, Progress progress) {
        this.reIndex(maybeOptions, searchQuery, new Context(this, progress));
    }

    @Override
    public void reIndex(EnumSet<ReIndexOption> options, List<String> spaceKeys, Progress progress) {
        this.reIndex(options, spaceKeys, new Context(this, progress));
    }

    private void reIndex(EnumSet<ReIndexOption> maybeOptions, List<String> spaceKeys, Context ctx) {
        ctx.progress.reindexStarted(maybeOptions, spaceKeys);
        try {
            spaceKeys.forEach(spaceKey -> this.reIndex(maybeOptions, (ReIndexOption option) -> this.reIndex((ReIndexOption)option, (String)spaceKey, ctx), ctx));
            ctx.reindexFinished(spaceKeys, maybeOptions);
        }
        catch (Exception e) {
            log.error("Reindex failed", (Throwable)e);
            ctx.progress.reIndexFailed();
        }
    }

    private void reIndex(EnumSet<ReIndexOption> maybeOptions, SearchQuery searchQuery, Context ctx) {
        ctx.progress.reindexStarted(maybeOptions, Collections.emptyList());
        try {
            this.reIndex(maybeOptions, (ReIndexOption option) -> this.reIndex((ReIndexOption)option, searchQuery, ctx), ctx);
            ctx.reindexFinished(Collections.emptyList(), maybeOptions);
        }
        catch (Exception e) {
            log.error("Reindex failed", (Throwable)e);
            ctx.progress.reIndexFailed();
        }
    }

    private void reIndex(EnumSet<ReIndexOption> maybeOptions, Consumer<ReIndexOption> consumer, Context ctx) {
        EnumSet<ReIndexOption> options = maybeOptions == null ? ReIndexOption.fullReindex() : maybeOptions;
        options.forEach(option -> {
            ctx.progress.reindexStageStarted((ReIndexOption)option);
            consumer.accept((ReIndexOption)option);
            ctx.progress.reindexStageFinished((ReIndexOption)option);
        });
    }

    private void reIndex(ReIndexOption option, String spaceKey, Context ctx) {
        log.info("Indexing of space {} starting for stage {}", (Object)spaceKey, (Object)option);
        this.reIndex(new ReIndexSpec(option.getDeleteQuery(Optional.of(spaceKey)), option.getThreadCount(), option.getHandles(this.searchableDao, Optional.ofNullable(spaceKey)), option.name(), false), ctx);
        log.info("Indexing of space {} completed for stage {}", (Object)spaceKey, (Object)option);
    }

    private void reIndex(ReIndexOption option, SearchQuery searchQuery, Context ctx) {
        log.info("Indexing starting for stage {}", (Object)option);
        LinkedHashSet handles = new LinkedHashSet();
        this.contentIndexAccessor.scan(searchQuery, Collections.singleton(SearchFieldMappings.HANDLE.getName()), fieldValues -> {
            String[] values = (String[])fieldValues.get(SearchFieldMappings.HANDLE.getName());
            if (values.length > 0) {
                try {
                    com.atlassian.confluence.core.persistence.hibernate.HibernateHandle handle = new com.atlassian.confluence.core.persistence.hibernate.HibernateHandle(values[0]);
                    if (option.getClassFilter().test(handle.getClassName())) {
                        handles.add(handle);
                    }
                }
                catch (ParseException ignored) {
                    log.error("Error when parsing handle field value {}", (Object)values[0]);
                }
            }
        });
        SearchQuery deleteQuery = (SearchQuery)BooleanQuery.builder().addMust(searchQuery).addMust(option.getDeleteQuery()).build();
        this.reIndex(new ReIndexSpec(deleteQuery, option.getThreadCount(), new ArrayList<com.atlassian.confluence.core.persistence.hibernate.HibernateHandle>(handles), option.name(), true, true), ctx);
        log.info("Indexing completed for stage {}", (Object)option);
    }

    private void reIndex(ReIndexOption option, Context ctx) {
        log.info("Indexing starting for stage {}", (Object)option);
        ReIndexSpec reIndexSpec = new ReIndexSpec(option.getDeleteQuery(), option.getThreadCount(), option.getHandles(this.searchableDao), option.name(), true, true);
        this.reIndex(reIndexSpec, ctx);
        log.info("Indexing completed for stage {}", (Object)option);
    }

    @VisibleForTesting
    int getMaxPartitionSize(int concurrencyLevel) {
        int partitionSize = Integer.getInteger(KEY_REINDEX_PARTITION_SIZE_MAX, 100000);
        if (partitionSize < concurrencyLevel) {
            log.warn("provided value {} for {} is less than concurrencyLevel {}, resetting to {}", new Object[]{partitionSize, KEY_REINDEX_PARTITION_SIZE_MAX, concurrencyLevel, concurrencyLevel});
            return concurrencyLevel;
        }
        return partitionSize;
    }

    private void reIndex(ReIndexSpec spec, Context ctx) {
        int concurrencyLevel = spec.getConcurrencyLevel();
        int maxPartitionSize = this.getMaxPartitionSize(concurrencyLevel);
        Deque groups = spec.getHandles().stream().collect(Collectors.groupingBy(HibernateHandle::getClassName)).values().stream().flatMap(group -> Lists.partition((List)group, (int)maxPartitionSize).stream().map(ArrayList::new)).collect(Collectors.toCollection(ArrayDeque::new));
        try {
            spec.getHandles().clear();
        }
        catch (UnsupportedOperationException e) {
            log.warn("unable to clear list of {}", spec.getHandles().getClass());
        }
        log.info("full reindex partitions for {} and concurrency level {}, total {} groups", new Object[]{spec.getName(), concurrencyLevel, groups.size()});
        BatchUpdateAction batchUpdateAction = () -> this.changeIndexAccessor.withBatchUpdate(() -> this.reIndex(spec, ctx, groups));
        this.contentIndexAccessor.withBatchUpdate(batchUpdateAction);
    }

    private void reIndex(ReIndexSpec spec, Context ctx, Deque<List<com.atlassian.confluence.core.persistence.hibernate.HibernateHandle>> groups) {
        String specName = spec.getName();
        SearchQuery deleteQuery = spec.getDeleteQuery();
        this.makeSureJournalExistsInDB();
        List<JournalEntry> latestJournalEntries = this.getJournalsLatestEntries();
        ctx.contentExecutor.execute(contentIndexWriter -> ctx.changeExecutor.execute(changesIndexWriter -> {
            log.info("full reindex starting for {}, deleting documents from index", (Object)specName);
            if (spec.shouldOptimize()) {
                log.info("Pre-optimizing indices...");
                contentIndexWriter.preOptimize();
                changesIndexWriter.preOptimize();
            }
            int numGroups = groups.size();
            AtomicInteger count = new AtomicInteger(0);
            contentIndexWriter.delete(deleteQuery);
            changesIndexWriter.delete(deleteQuery);
            log.info("full reindex documents deleted for {}, starting full reindex", (Object)specName);
            while (!groups.isEmpty()) {
                List handles = (List)groups.pop();
                BatchIndexer concurrentIndexer = this.batchIndexerFactory.createConcurrentIndexer(spec, contentIndexWriter, changesIndexWriter);
                concurrentIndexer.index(handles, ctx.progress);
                log.info("reindex group {}/{} completed for {}, {}% complete", new Object[]{count.incrementAndGet(), numGroups, spec.getName(), ctx.progress.getPercentComplete()});
            }
            log.info("full reindex completed for {}, {}% complete, start cleaning up files", (Object)specName, (Object)ctx.progress.getPercentComplete());
            if (spec.shouldOptimize()) {
                log.info("Post-optimizing indices...");
                contentIndexWriter.postOptimize();
                changesIndexWriter.postOptimize();
            }
            log.info("full reindex cleanup completed for {}", (Object)specName);
        }));
        if (spec.shouldResetJournal()) {
            this.setJournalsLatestEntries(latestJournalEntries);
        }
    }

    @VisibleForTesting
    ReindexProgress reindexProgress(Progress progress) {
        return new EventPublishingReindexProgress(this.eventPublisher, progress);
    }

    @VisibleForTesting
    List<JournalEntry> getJournalsLatestEntries() {
        return INDEXES_TO_SET_EARLIEST_ENTRY.stream().map(index -> this.getMostRecentId(index.getJournalIdentifier())).flatMap(Optional::stream).collect(Collectors.toCollection(ArrayList::new));
    }

    private Optional<JournalEntry> getMostRecentId(JournalIdentifier journalIdentifier) {
        try {
            Optional<JournalEntry> entry = this.journalManager.getMostRecentId(journalIdentifier);
            if (entry.isPresent()) {
                log.info("the latest entry for {} is {}", (Object)journalIdentifier.getJournalName(), (Object)entry.get().getId());
            } else {
                log.info("{} has no entries", (Object)journalIdentifier.getJournalName());
            }
            return entry;
        }
        catch (Exception e) {
            log.error("unable to get the latest entry for {}", (Object)journalIdentifier.getJournalName());
            return Optional.empty();
        }
    }

    @VisibleForTesting
    boolean setJournalsLatestEntries(List<JournalEntry> entries) {
        AtomicBoolean result = new AtomicBoolean(true);
        entries.forEach(entry -> {
            JournalIdentifier journalIdentifier = entry.getJournalId();
            long entryId = entry.getId();
            try {
                this.journalManager.setMostRecentId(journalIdentifier, entryId);
                log.info("{} storage was set to the latest entry {}", (Object)journalIdentifier.getJournalName(), (Object)entryId);
            }
            catch (Exception e) {
                result.set(false);
                log.error("unable to set {} storage to the latest journal entry", (Object)journalIdentifier.getJournalName());
            }
        });
        return result.get();
    }

    private void makeSureJournalExistsInDB() {
        INDEXES_TO_SNAPSHOT.stream().forEach(index -> this.journalService.enqueue(new com.atlassian.confluence.api.model.journal.JournalEntry(index.getJournalIdentifier(), "NO_OP", "Placeholder journal only, safe to ignore.")));
    }

    protected class Context {
        private final ReindexProgress progress;
        private final Executor contentExecutor;
        private final Executor changeExecutor;

        protected Context(AbstractReindexer this$0, Progress progress) {
            this(this$0, progress, this$0.contentIndexAccessor::execute, this$0.changeIndexAccessor::execute);
        }

        protected Context(AbstractReindexer this$0, Progress progress, Executor contentExecutor, Executor changeExecutor) {
            this.progress = this$0.reindexProgress(progress);
            this.contentExecutor = contentExecutor;
            this.changeExecutor = changeExecutor;
        }

        public void reindexFinished(List<String> spaceKeys, EnumSet<ReIndexOption> options) {
            this.progress.reindexFinished(spaceKeys, options);
        }

        protected static interface Executor {
            public void execute(SearchIndexAction var1) throws SearchIndexAccessException;
        }
    }
}

