/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.index;

import com.atlassian.confluence.dmz.hibernate.AnyTypeDaoInternal;
import com.atlassian.confluence.index.ReIndexSpec;
import com.atlassian.confluence.internal.index.BatchIndexer;
import com.atlassian.confluence.internal.index.BulkFieldPrefetcher;
import com.atlassian.confluence.internal.index.ChangeBatchIndexer;
import com.atlassian.confluence.internal.index.ConcurrentBatchIndexer;
import com.atlassian.confluence.internal.index.ConcurrentBatchIndexerExecutorServiceFactory;
import com.atlassian.confluence.internal.index.DefaultBatchIndexer;
import com.atlassian.confluence.internal.search.SearchLanguageProvider;
import com.atlassian.confluence.search.v2.SearchIndexWriter;
import com.atlassian.sal.api.features.DarkFeatureManager;
import org.springframework.transaction.PlatformTransactionManager;

class BatchIndexerFactory {
    private final AnyTypeDaoInternal anyTypeDao;
    private final PlatformTransactionManager transactionManager;
    private final BulkFieldPrefetcher bulkFieldPrefetcher;
    private final ConcurrentBatchIndexerExecutorServiceFactory executorServiceFactory;
    private final DarkFeatureManager darkFeatureManager;
    private final SearchLanguageProvider searchLanguageProvider;
    private final ChangeBatchIndexer changeBatchIndexer;

    BatchIndexerFactory(AnyTypeDaoInternal anyTypeDao, PlatformTransactionManager transactionManager, BulkFieldPrefetcher bulkFieldPrefetcher, ConcurrentBatchIndexerExecutorServiceFactory executorServiceFactory, DarkFeatureManager darkFeatureManager, SearchLanguageProvider searchLanguageProvider, ChangeBatchIndexer changeBatchIndexer) {
        this.anyTypeDao = anyTypeDao;
        this.transactionManager = transactionManager;
        this.bulkFieldPrefetcher = bulkFieldPrefetcher;
        this.executorServiceFactory = executorServiceFactory;
        this.darkFeatureManager = darkFeatureManager;
        this.searchLanguageProvider = searchLanguageProvider;
        this.changeBatchIndexer = changeBatchIndexer;
    }

    BatchIndexer createConcurrentIndexer(ReIndexSpec reIndexSpec, SearchIndexWriter contentWriter, SearchIndexWriter changeWriter) {
        return new ConcurrentBatchIndexer(new DefaultBatchIndexer(this.anyTypeDao, this.transactionManager, contentWriter, changeWriter, this.bulkFieldPrefetcher, this.darkFeatureManager, this.searchLanguageProvider, this.changeBatchIndexer), reIndexSpec.getConcurrencyLevel(), this.executorServiceFactory);
    }
}

