/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.index;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.api.service.journal.JournalService;
import com.atlassian.confluence.core.persistence.SearchableDao;
import com.atlassian.confluence.impl.journal.JournalEntry;
import com.atlassian.confluence.impl.journal.JournalManager;
import com.atlassian.confluence.internal.index.AbstractReindexer;
import com.atlassian.confluence.internal.index.BatchIndexerFactory;
import com.atlassian.confluence.search.ReIndexOption;
import com.atlassian.confluence.search.v2.Index;
import com.atlassian.confluence.search.v2.SearchIndexAccessor;
import com.atlassian.confluence.search.v2.StagingIndexFactory;
import com.atlassian.confluence.util.Progress;
import com.atlassian.event.api.EventPublisher;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;

@Internal
public class BlueGreenReindexer
extends AbstractReindexer {
    private final StagingIndexFactory stagingIndexFactory;

    public BlueGreenReindexer(SearchableDao searchableDao, SearchIndexAccessor contentIndexAccessor, SearchIndexAccessor changeIndexAccessor, EventPublisher eventPublisher, BatchIndexerFactory batchIndexerFactory, JournalManager journalManager, JournalService journalService, StagingIndexFactory stagingIndexFactory) {
        super(searchableDao, contentIndexAccessor, changeIndexAccessor, eventPublisher, batchIndexerFactory, journalManager, journalService);
        this.stagingIndexFactory = Objects.requireNonNull(stagingIndexFactory);
    }

    @Override
    public void reIndex(EnumSet<ReIndexOption> maybeOptions, Progress progress) {
        if (ReIndexOption.isFullReindex(maybeOptions)) {
            List<JournalEntry> latestEntries = this.getJournalsLatestEntries();
            try (StagingIndexFactory.StagingIndex contentDraft = this.stagingIndexFactory.createStagingIndex(Index.CONTENT);
                 StagingIndexFactory.StagingIndex changeDraft = this.stagingIndexFactory.createStagingIndex(Index.CHANGE);){
                this.reIndex(maybeOptions, new BlueGreenContext(this, progress, contentDraft, changeDraft));
            }
            latestEntries.forEach(journalEntry -> this.journalManager.setMostRecentId(journalEntry.getJournalId(), journalEntry.getId()));
        } else {
            super.reIndex(maybeOptions, progress);
        }
    }

    @Override
    public boolean shouldSuspendJournalFlush() {
        return false;
    }

    private class BlueGreenContext
    extends AbstractReindexer.Context
    implements AutoCloseable {
        private final StagingIndexFactory.StagingIndex contentDraft;
        private final StagingIndexFactory.StagingIndex changeDraft;

        protected BlueGreenContext(BlueGreenReindexer blueGreenReindexer, Progress progress, StagingIndexFactory.StagingIndex contentDraft, StagingIndexFactory.StagingIndex changeDraft) {
            super(blueGreenReindexer, progress, contentDraft::execute, changeDraft::execute);
            this.contentDraft = contentDraft;
            this.changeDraft = changeDraft;
        }

        @Override
        public void reindexFinished(List<String> spaceKeys, EnumSet<ReIndexOption> options) {
            this.contentDraft.activate();
            this.changeDraft.activate();
            super.reindexFinished(spaceKeys, options);
        }

        @Override
        public void close() {
            this.contentDraft.close();
            this.changeDraft.close();
        }
    }
}

