/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.index;

import bucket.core.persistence.hibernate.HibernateHandle;
import com.atlassian.annotations.Internal;
import com.atlassian.bonnie.Handle;
import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.persistence.hibernate.CacheMode;
import com.atlassian.confluence.core.persistence.hibernate.SessionCacheModeThreadLocal;
import com.atlassian.confluence.dmz.hibernate.AnyTypeDaoInternal;
import com.atlassian.confluence.internal.index.BatchIndexer;
import com.atlassian.confluence.internal.index.BulkFieldPrefetcher;
import com.atlassian.confluence.internal.index.ChangeBatchIndexer;
import com.atlassian.confluence.internal.index.ReindexProgress;
import com.atlassian.confluence.internal.search.SearchLanguageProvider;
import com.atlassian.confluence.search.SearchLanguage;
import com.atlassian.confluence.search.v2.AtlassianDocument;
import com.atlassian.confluence.search.v2.SearchIndexWriter;
import com.atlassian.confluence.util.Cleanup;
import com.atlassian.sal.api.features.DarkFeatureManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;

@Internal
public class DefaultBatchIndexer
implements BatchIndexer {
    private static final Logger log = LoggerFactory.getLogger(DefaultBatchIndexer.class);
    public static final String DISABLE_INDEX_IMPROVEMENTS_DARK_FEATURE_KEY = "confluence.indexing.improvements.disable";
    private final AnyTypeDaoInternal anyTypeDao;
    private final PlatformTransactionManager transactionManager;
    private final SearchIndexWriter contentWriter;
    private final SearchIndexWriter changeWriter;
    private final BulkFieldPrefetcher bulkFieldPrefetcher;
    private final DarkFeatureManager darkFeatureManager;
    private final ChangeBatchIndexer changeBatchIndexer;
    private final SearchLanguageProvider searchLanguageProvider;

    public DefaultBatchIndexer(AnyTypeDaoInternal anyTypeDao, PlatformTransactionManager transactionManager, SearchIndexWriter contentWriter, SearchIndexWriter changeWriter, BulkFieldPrefetcher bulkFieldPrefetcher, DarkFeatureManager darkFeatureManager, SearchLanguageProvider searchLanguageProvider, ChangeBatchIndexer changeBatchIndexer) {
        this.anyTypeDao = Objects.requireNonNull(anyTypeDao);
        this.transactionManager = Objects.requireNonNull(transactionManager);
        this.contentWriter = Objects.requireNonNull(contentWriter);
        this.changeWriter = Objects.requireNonNull(changeWriter);
        this.bulkFieldPrefetcher = Objects.requireNonNull(bulkFieldPrefetcher);
        this.darkFeatureManager = darkFeatureManager;
        this.changeBatchIndexer = Objects.requireNonNull(changeBatchIndexer);
        this.searchLanguageProvider = Objects.requireNonNull(searchLanguageProvider);
    }

    @Override
    public void index(List<com.atlassian.confluence.core.persistence.hibernate.HibernateHandle> handles, ReindexProgress progress) {
        try (Cleanup ignore = SessionCacheModeThreadLocal.temporarilySetCacheMode((CacheMode)CacheMode.IGNORE);){
            String entityClassName = DefaultBatchIndexer.getEntityClassName(handles);
            new TransactionTemplate(this.transactionManager, DefaultBatchIndexer.createTxDef()).execute(transactionStatus -> {
                List<Searchable> indexableSearchables = this.getSearchables(handles, entityClassName);
                if (indexableSearchables.isEmpty()) {
                    log.debug("No searchables of type {} in a re-indexing batch were considered indexable.", (Object)entityClassName);
                    return null;
                }
                this.doIndex(indexableSearchables, entityClassName);
                return null;
            });
        }
    }

    private static TransactionDefinition createTxDef() {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition(3);
        def.setReadOnly(true);
        return def;
    }

    private static String getEntityClassName(Collection<com.atlassian.confluence.core.persistence.hibernate.HibernateHandle> handles) {
        return handles.iterator().next().getClassName();
    }

    private List<Searchable> getSearchables(List<com.atlassian.confluence.core.persistence.hibernate.HibernateHandle> handles, String className) {
        List result;
        List<Long> ids = handles.stream().filter(x -> x.getClassName().equals(className)).map(HibernateHandle::getId).collect(Collectors.toList());
        if (handles.size() != ids.size()) {
            throw new IllegalArgumentException("The list of handles must be of the same class");
        }
        try {
            if (!this.darkFeatureManager.isEnabledForAllUsers(DISABLE_INDEX_IMPROVEMENTS_DARK_FEATURE_KEY).orElse(false).booleanValue()) {
                AnyTypeDaoInternal anyTypeDaoInternal = this.anyTypeDao;
                result = anyTypeDaoInternal.findSearchableByIdsAndClassNameWithBody(ids, className);
            } else {
                result = this.anyTypeDao.findByIdsAndClassName(ids, className);
            }
        }
        catch (ObjectRetrievalFailureException e) {
            log.warn("Unable to retrieve collection of searchable. Falling back to individual retrieval. {}", (Object)e.getMessage(), (Object)e);
            result = this.retrieveObjectsIndividuallyAndLogFailures(handles);
        }
        List<Searchable> indexableSearchables = result.stream().filter(Searchable::isIndexable).collect(Collectors.toList());
        return indexableSearchables;
    }

    private List<Searchable> retrieveObjectsIndividuallyAndLogFailures(List<com.atlassian.confluence.core.persistence.hibernate.HibernateHandle> handles) {
        ArrayList<Searchable> result = new ArrayList<Searchable>(handles.size());
        for (com.atlassian.confluence.core.persistence.hibernate.HibernateHandle handle : handles) {
            try {
                result.add((Searchable)this.anyTypeDao.findByHandle((Handle)handle));
            }
            catch (ObjectRetrievalFailureException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Unable to retrieve single object: {}", (Object)e.getMessage(), (Object)e);
                    continue;
                }
                log.warn("Unable to retrieve single object: {}", (Object)e.getMessage());
            }
        }
        return result;
    }

    private void doIndex(List<Searchable> searchables, String entityClassName) {
        this.doIndex(searchables, this.bulkFieldPrefetcher.createPrefetchedDocumentBuilder(searchables, entityClassName));
    }

    private void doIndex(List<Searchable> searchables, Function<Searchable, AtlassianDocument> documentBuilder) {
        log.debug("Indexing {} items for Content index in batch", (Object)searchables.size());
        SearchLanguage searchLanguage = this.searchLanguageProvider.get();
        for (Searchable searchable : searchables) {
            try {
                if (searchable != null) {
                    log.debug("Index {} [{}]", (Object)searchable, (Object)searchable.getClass().getName());
                }
                this.tryIndex(searchable, documentBuilder, this.contentWriter, searchLanguage);
            }
            catch (IOException | RuntimeException e) {
                if (searchable != null) {
                    log.error("Exception indexing document with id: {}", (Object)searchable.getId(), (Object)e);
                    continue;
                }
                log.error("Error indexing document", (Throwable)e);
            }
        }
        try {
            log.debug("Indexing {} items for Change indexer in batch", (Object)searchables.size());
            this.changeBatchIndexer.index(searchables, this.changeWriter);
        }
        catch (IOException | RuntimeException e) {
            log.error("Error indexing change documents in batch", (Throwable)e);
        }
    }

    private void tryIndex(Searchable searchable, Function<Searchable, AtlassianDocument> documentBuilder, SearchIndexWriter writer, SearchLanguage searchLanguage) throws IOException {
        try {
            AtlassianDocument atlassianDocument = documentBuilder.apply(searchable);
            atlassianDocument.setSearchLanguage(Optional.ofNullable(searchLanguage));
            writer.add(atlassianDocument);
        }
        catch (IOException | RuntimeException e) {
            log.warn("Error getting document from searchable", (Throwable)e);
        }
    }
}

