/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.index;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.bonnie.Searchable;
import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.config.internal.ApplicationConfig;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.core.AbstractVersionedEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.Versioned;
import com.atlassian.confluence.impl.hibernate.Hibernate;
import com.atlassian.confluence.impl.hibernate.HibernateSessionManager5;
import com.atlassian.confluence.internal.index.BulkFieldPrefetcher;
import com.atlassian.confluence.internal.index.ChangeBatchIndexer;
import com.atlassian.confluence.internal.index.lucene.LuceneChangeExtractor;
import com.atlassian.confluence.internal.persistence.ContentEntityObjectDaoInternal;
import com.atlassian.confluence.internal.search.ChangeDocumentIdBuilder;
import com.atlassian.confluence.internal.search.ChangeDocumentIndexPolicy;
import com.atlassian.confluence.internal.search.IndexTaskFactoryInternal;
import com.atlassian.confluence.search.SearchPlatform;
import com.atlassian.confluence.search.v2.AtlassianDocument;
import com.atlassian.confluence.search.v2.AtlassianDocumentBuilder;
import com.atlassian.confluence.search.v2.SearchIndexWriter;
import com.atlassian.confluence.search.v2.query.TermQuery;
import com.atlassian.confluence.user.ConfluenceUser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultChangeBatchIndexer
implements ChangeBatchIndexer {
    private static final Logger logger = LoggerFactory.getLogger(DefaultChangeBatchIndexer.class);
    @VisibleForTesting
    int LAST_EDITED_VERSION_BATCH_SIZE = 20;
    private final HibernateSessionManager5 hibernateSessionManager;
    private final IndexTaskFactoryInternal indexTaskFactory;
    private final ContentEntityObjectDaoInternal contentEntityObjectDao;
    private final ChangeDocumentIdBuilder changeDocumentIdBuilder;
    private final AtlassianDocumentBuilder<Searchable> changeDocumentBuilder;
    private final BulkFieldPrefetcher bulkFieldPrefetcher;
    private final boolean skipDeletes;

    public DefaultChangeBatchIndexer(HibernateSessionManager5 hibernateSessionManager, IndexTaskFactoryInternal indexTaskFactory, ContentEntityObjectDaoInternal contentEntityObjectDao, AtlassianDocumentBuilder<Searchable> changeDocumentBuilder, ApplicationConfig applicationConfig, BulkFieldPrefetcher bulkFieldPrefetcher) {
        this.hibernateSessionManager = Objects.requireNonNull(hibernateSessionManager);
        this.indexTaskFactory = Objects.requireNonNull(indexTaskFactory);
        this.contentEntityObjectDao = Objects.requireNonNull(contentEntityObjectDao);
        this.changeDocumentIdBuilder = new ChangeDocumentIdBuilder();
        this.changeDocumentBuilder = Objects.requireNonNull(changeDocumentBuilder);
        this.bulkFieldPrefetcher = Objects.requireNonNull(bulkFieldPrefetcher);
        this.skipDeletes = SearchPlatform.getSearchPlatform((ApplicationConfiguration)applicationConfig).isSupportsDocumentId();
    }

    @Override
    public void index(List<Searchable> searchables, SearchIndexWriter changeWriter) throws IOException {
        List<Searchable> indexableEntities = searchables.stream().filter(ChangeDocumentIndexPolicy::shouldIndex).toList();
        List<Searchable> latestVersionSearchables = indexableEntities.stream().filter(searchable -> searchable instanceof Versioned && ((Versioned)searchable).isLatestVersion()).toList();
        List<Searchable> initialChangeIndexableEntities = indexableEntities.stream().filter(searchable -> !(searchable instanceof Versioned) || !((Versioned)searchable).isLatestVersion()).toList();
        this.rebuiltChangeDocuments(changeWriter, latestVersionSearchables);
        this.addChangeDocuments(changeWriter, initialChangeIndexableEntities);
    }

    private void addChangeDocuments(SearchIndexWriter changeWriter, List<Searchable> initialChangeIndexableEntities) throws IOException {
        logger.debug("Adding Change Index for {}", (Object)initialChangeIndexableEntities.size());
        Function<Searchable, AtlassianDocument> prefetchedChangeDocumentBuilder = this.getPrefetchedChangeDocumentBuilder(initialChangeIndexableEntities);
        for (Searchable searchable : initialChangeIndexableEntities) {
            if (searchable instanceof Versioned && !this.skipDeletes) {
                logger.debug("Add Change Index: clean up current version only");
                changeWriter.delete(new TermQuery(LuceneChangeExtractor.Mappings.CHANGE_DOCUMENT_AND_AUTHOR_ID.getName(), this.changeDocumentIdBuilder.getChangeDocumentAndAuthorId(searchable)));
            }
            this.tryAddChangeDocument(changeWriter, searchable, prefetchedChangeDocumentBuilder);
        }
    }

    private Function<Searchable, AtlassianDocument> getPrefetchedChangeDocumentBuilder(List<Searchable> initialChangeIndexableEntities) {
        if (initialChangeIndexableEntities.isEmpty()) {
            return this.changeDocumentBuilder::build;
        }
        String entityClassName = Hibernate.getClass((Object)initialChangeIndexableEntities.iterator().next()).getName();
        Function<Searchable, AtlassianDocument> prefetchedChangeDocumentBuilder = this.bulkFieldPrefetcher.createPrefetchedDocumentBuilder(initialChangeIndexableEntities, entityClassName);
        return prefetchedChangeDocumentBuilder;
    }

    private void rebuiltChangeDocuments(SearchIndexWriter changeWriter, List<Searchable> latestVersionSearchables) throws IOException {
        logger.debug("Rebuilt Change Index for {}", (Object)latestVersionSearchables.size());
        Map<ContentId, List<ContentEntityObject>> lastEditedVersionsByContentId = this.getLastEditedVersionsOf(latestVersionSearchables);
        if (!this.skipDeletes) {
            logger.debug("Rebuilt Change Index: clean up current versions");
            for (Searchable searchable : latestVersionSearchables) {
                this.indexTaskFactory.createDeleteChangeDocumentsIndexTask(searchable).perform(changeWriter);
            }
        }
        for (Map.Entry<ContentId, List<ContentEntityObject>> entry : lastEditedVersionsByContentId.entrySet()) {
            ArrayList<Searchable> changeIndexableEntities = new ArrayList<ContentEntityObject>();
            List<ContentEntityObject> lastEditedVersions = entry.getValue();
            if (this.skipDeletes) {
                lastEditedVersions = new ArrayList(lastEditedVersions.stream().collect(Collectors.toMap(AbstractVersionedEntityObject::getVersion, Function.identity(), (s, t) -> s)).values());
            }
            changeIndexableEntities.addAll(lastEditedVersions);
            changeIndexableEntities = changeIndexableEntities.stream().filter(ChangeDocumentIndexPolicy::shouldIndex).toList();
            Function<Searchable, AtlassianDocument> prefetchedChangeDocumentBuilder = this.getPrefetchedChangeDocumentBuilder(changeIndexableEntities);
            this.hibernateSessionManager.executeThenClearSessionWithoutCommitOrFlush(changeIndexableEntities, this.LAST_EDITED_VERSION_BATCH_SIZE, changeIndexableEntities.size(), ceo -> {
                this.tryAddChangeDocument(changeWriter, (Searchable)ceo, prefetchedChangeDocumentBuilder);
                return null;
            });
        }
    }

    private Map<ContentId, List<ContentEntityObject>> getLastEditedVersionsOf(List<Searchable> latestVersionSearchables) {
        List<ContentId> latestVersionContentIds = latestVersionSearchables.stream().map(searchable -> ContentId.of((long)searchable.getId())).toList();
        Map<Long, Searchable> idToSearchable = latestVersionSearchables.stream().collect(Collectors.toMap(searchable -> searchable.getId(), searchable -> searchable));
        Map<ContentId, List<ContentEntityObject>> lastEditedVersionsByContentId = new HashMap<ContentId, List<ContentEntityObject>>();
        if (latestVersionContentIds.isEmpty()) {
            logger.debug("No latest versions found so we cannot get last edited versions");
            return lastEditedVersionsByContentId;
        }
        lastEditedVersionsByContentId = this.contentEntityObjectDao.getLastEditedOldVersionsOf(latestVersionContentIds);
        for (ContentId contentId : latestVersionContentIds) {
            ContentEntityObject currentVersion = (ContentEntityObject)idToSearchable.get(contentId.asLong());
            List<ContentEntityObject> oldLastEditedVersions = lastEditedVersionsByContentId.get(contentId);
            if (oldLastEditedVersions == null) {
                lastEditedVersionsByContentId.put(contentId, List.of(currentVersion));
                continue;
            }
            ConfluenceUser lastModifierOfCurrentVersion = currentVersion.getLastModifier();
            Optional<ContentEntityObject> sameModifierWithLatestVersionOpt = oldLastEditedVersions.stream().filter(oldEditVersion -> lastModifierOfCurrentVersion != null && lastModifierOfCurrentVersion.equals(oldEditVersion.getLastModifier())).findFirst();
            if (sameModifierWithLatestVersionOpt.isPresent()) {
                oldLastEditedVersions.remove(sameModifierWithLatestVersionOpt.get());
                oldLastEditedVersions.add(currentVersion);
                continue;
            }
            oldLastEditedVersions.add(currentVersion);
        }
        return lastEditedVersionsByContentId;
    }

    private void tryAddChangeDocument(SearchIndexWriter writer, Searchable searchable, Function<Searchable, AtlassianDocument> documentBuilder) {
        try {
            AtlassianDocument atlassianDocument = documentBuilder.apply(searchable);
            writer.add(atlassianDocument);
        }
        catch (IOException | RuntimeException e) {
            if (searchable != null) {
                logger.error("Exception indexing document with id: {}", (Object)searchable.getId(), (Object)e);
            }
            logger.error("Error indexing document", (Throwable)e);
        }
    }
}

