/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.index;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.api.service.journal.JournalService;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ReIndexingScopeThreadLocal;
import com.atlassian.confluence.core.persistence.SearchableDao;
import com.atlassian.confluence.impl.journal.JournalManager;
import com.atlassian.confluence.impl.system.SystemMaintenanceTaskQueue;
import com.atlassian.confluence.impl.system.task.CreateIndexSnapshotMaintenanceTask;
import com.atlassian.confluence.internal.index.AbstractReindexer;
import com.atlassian.confluence.internal.index.BatchIndexerFactory;
import com.atlassian.confluence.search.ReIndexOption;
import com.atlassian.confluence.search.v2.SearchIndexAccessor;
import com.atlassian.event.api.EventPublisher;
import java.util.EnumSet;
import java.util.Objects;

@Internal
public class PropagableReindexer
extends AbstractReindexer {
    private final ClusterManager clusterManager;
    private final SystemMaintenanceTaskQueue systemMaintenanceTaskQueue;

    public PropagableReindexer(SearchableDao searchableDao, SearchIndexAccessor contentIndexAccessor, SearchIndexAccessor changeIndexAccessor, EventPublisher eventPublisher, BatchIndexerFactory batchIndexerFactory, JournalManager journalManager, JournalService journalService, ClusterManager clusterManager, SystemMaintenanceTaskQueue systemMaintenanceTaskQueue) {
        super(searchableDao, contentIndexAccessor, changeIndexAccessor, eventPublisher, batchIndexerFactory, journalManager, journalService);
        this.clusterManager = Objects.requireNonNull(clusterManager);
        this.systemMaintenanceTaskQueue = Objects.requireNonNull(systemMaintenanceTaskQueue);
    }

    @Override
    protected void reIndex(EnumSet<ReIndexOption> maybeOptions, AbstractReindexer.Context ctx) {
        super.reIndex(maybeOptions, ctx);
        if (this.needToPropagateSnapshot()) {
            this.systemMaintenanceTaskQueue.enqueue(new CreateIndexSnapshotMaintenanceTask(Objects.requireNonNull(this.clusterManager.getThisNodeInformation()).getAnonymizedNodeIdentifier(), INDEXES_TO_SNAPSHOT));
        }
    }

    private boolean needToPropagateSnapshot() {
        return this.clusterManager.isClustered() && ReIndexingScopeThreadLocal.currentScope() == ReIndexingScopeThreadLocal.ReIndexingScope.CLUSTER_WIDE;
    }

    @Override
    public boolean shouldSuspendJournalFlush() {
        return true;
    }
}

