/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.index.lucene;

import com.atlassian.confluence.internal.index.IndexLockService;
import com.atlassian.confluence.internal.search.LuceneIndependent;
import com.atlassian.confluence.search.v2.lucene.SearchIndex;
import com.google.common.base.Stopwatch;
import com.google.common.math.LongMath;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LuceneIndependent
public class DefaultIndexLockService
implements IndexLockService {
    private static final Logger log = LoggerFactory.getLogger(DefaultIndexLockService.class);
    private final Map<SearchIndex, ReentrantLock> lockByIndex = Stream.of(SearchIndex.values()).collect(Collectors.toMap(Function.identity(), index -> new ReentrantLock()));

    @Override
    public boolean tryLock(SearchIndex index, long duration, TimeUnit timeUnit) {
        return this.tryLock(EnumSet.of(index), duration, timeUnit);
    }

    @Override
    public boolean tryLock(EnumSet<SearchIndex> indices, long duration, TimeUnit timeUnit) {
        long singleIndexDuration = LongMath.divide((long)duration, (long)indices.size(), (RoundingMode)RoundingMode.UP);
        ArrayList<ReentrantLock> acquiredLocks = new ArrayList<ReentrantLock>();
        Stopwatch overallStopwatch = Stopwatch.createStarted();
        try {
            for (SearchIndex index : indices) {
                ReentrantLock lock = this.lockByIndex.get((Object)index);
                Stopwatch indexStopwatch = Stopwatch.createStarted();
                boolean gotLock = lock.tryLock(singleIndexDuration, timeUnit);
                if (gotLock) {
                    log.debug("Lock acquired for index {} in {} ms", (Object)index, (Object)indexStopwatch.elapsed(TimeUnit.MILLISECONDS));
                }
                if (!gotLock) {
                    log.debug("Lock timed out for index {} in {} ms. Releasing all other locks...", (Object)index, (Object)indexStopwatch.elapsed(TimeUnit.MILLISECONDS));
                    indexStopwatch.reset().start();
                    acquiredLocks.forEach(ReentrantLock::unlock);
                    log.debug("All other locks released in {} ms", (Object)indexStopwatch.elapsed(TimeUnit.MILLISECONDS));
                    log.debug("failed in {} ms", (Object)overallStopwatch.elapsed(TimeUnit.MILLISECONDS));
                    return false;
                }
                acquiredLocks.add(lock);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.debug("Lock attempt interrupted. Releasing all other locks...");
            Stopwatch indexStopwatch = Stopwatch.createStarted();
            acquiredLocks.forEach(ReentrantLock::unlock);
            log.debug("All other locks released in {} ms", (Object)indexStopwatch.elapsed(TimeUnit.MILLISECONDS));
            log.debug("failed in {} ms", (Object)overallStopwatch.elapsed(TimeUnit.MILLISECONDS));
            return false;
        }
        log.debug("acquired all locks in {} ms", (Object)overallStopwatch.elapsed(TimeUnit.MILLISECONDS));
        return true;
    }

    @Override
    public void lock(SearchIndex index) {
        this.lock(EnumSet.of(index));
    }

    @Override
    public void lock(EnumSet<SearchIndex> indices) {
        Stopwatch overallStopwatch = Stopwatch.createStarted();
        for (SearchIndex index : indices) {
            Stopwatch indexStopwatch = Stopwatch.createStarted();
            this.lockByIndex.get((Object)index).lock();
            log.debug("Lock acquired for index {} in {} ms", (Object)index, (Object)indexStopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
        log.debug("acquired all locks in {} ms", (Object)overallStopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    @Override
    public void unlock(SearchIndex index) {
        this.unlock(EnumSet.of(index));
    }

    @Override
    public void unlock(EnumSet<SearchIndex> indices) {
        Stopwatch overallStopwatch = Stopwatch.createStarted();
        boolean exceptionThrown = false;
        for (SearchIndex index : indices) {
            try {
                this.lockByIndex.get((Object)index).unlock();
            }
            catch (IllegalMonitorStateException e) {
                exceptionThrown = true;
            }
        }
        log.debug("all locks unlocked in {} ms", (Object)overallStopwatch.elapsed(TimeUnit.MILLISECONDS));
        if (exceptionThrown) {
            throw new IllegalMonitorStateException("Can't release locks on " + String.valueOf(indices) + " because they are not held");
        }
    }
}

