/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.index.lucene.snapshot;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.api.model.journal.JournalIdentifier;
import com.atlassian.confluence.internal.index.AbstractReindexer;
import com.atlassian.confluence.internal.index.lucene.snapshot.LuceneIndexSnapshot;
import com.atlassian.confluence.internal.index.lucene.snapshot.LuceneIndexSnapshotManager;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndexSnapshotCleaner
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(LuceneIndexSnapshotCleaner.class);
    private static final int INDEX_SNAPSHOT_RETAIN_SIZE = Integer.getInteger("index.snapshot.retain.count", 3);
    private final LuceneIndexSnapshotManager snapshotManager;

    public LuceneIndexSnapshotCleaner(LuceneIndexSnapshotManager snapshotManager) {
        this.snapshotManager = Objects.requireNonNull(snapshotManager);
    }

    public @Nullable JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        AbstractReindexer.INDEXES_TO_SNAPSHOT.forEach(index -> this.cleanSnapshotsForJournal(index.getJournalIdentifier(), INDEX_SNAPSHOT_RETAIN_SIZE));
        return JobRunnerResponse.success();
    }

    @VisibleForTesting
    void cleanSnapshotsForJournal(JournalIdentifier journalIdentifier, int retainSize) {
        log.debug("Cleaning up index snapshots for journal {}", (Object)journalIdentifier);
        List<LuceneIndexSnapshot> snapshots = this.snapshotManager.findForJournal(journalIdentifier);
        while (snapshots.size() > retainSize) {
            LuceneIndexSnapshot oldestSnapshot = snapshots.get(snapshots.size() - 1);
            try {
                this.snapshotManager.delete(oldestSnapshot);
                log.debug("Deleted snapshot {}", (Object)oldestSnapshot);
            }
            catch (IOException e) {
                log.error("Error cleaning up index snapshot {}", (Object)oldestSnapshot, (Object)e);
                break;
            }
            snapshots = this.snapshotManager.findForJournal(journalIdentifier);
        }
    }
}

