/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.index.status;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.confluence.cluster.ReIndexingScopeThreadLocal;
import com.atlassian.confluence.event.events.admin.ReIndexFailedEvent;
import com.atlassian.confluence.event.events.admin.ReIndexJobFinishedEvent;
import com.atlassian.confluence.event.events.admin.ReIndexRequestEvent;
import com.atlassian.confluence.event.events.admin.ReIndexRequestFailedEvent;
import com.atlassian.confluence.event.events.admin.ReindexFinishedEvent;
import com.atlassian.confluence.event.events.admin.ReindexSkippedEvent;
import com.atlassian.confluence.event.events.admin.ReindexStartedEvent;
import com.atlassian.confluence.event.events.admin.RestoreIndexSnapshotStartedEvent;
import com.atlassian.confluence.impl.system.SystemMaintenanceTaskQueue;
import com.atlassian.confluence.impl.system.task.ReIndexMaintenanceTask;
import com.atlassian.confluence.index.status.ReIndexError;
import com.atlassian.confluence.index.status.ReIndexJob;
import com.atlassian.confluence.index.status.ReIndexNodeStatus;
import com.atlassian.confluence.index.status.ReIndexStage;
import com.atlassian.confluence.internal.index.event.IndexSnapshotCreationFailedEvent;
import com.atlassian.confluence.internal.index.event.IndexSnapshotCreationSuccessfulEvent;
import com.atlassian.confluence.internal.index.event.IndexSnapshotRestorationFailedEvent;
import com.atlassian.confluence.internal.index.event.IndexSnapshotRestorationSkippedEvent;
import com.atlassian.confluence.internal.index.event.IndexSnapshotRestoredSuccessfullyEvent;
import com.atlassian.confluence.internal.index.event.ReIndexFinishedAnalyticsEvent;
import com.atlassian.confluence.internal.index.event.ReIndexStartedAnalyticsEvent;
import com.atlassian.confluence.internal.index.event.ReindexAnalyticsEventPublishingHelper;
import com.atlassian.confluence.internal.index.event.SourceNodeLeftClusterDuringPropagationEvent;
import com.atlassian.confluence.internal.index.lucene.snapshot.IndexSnapshotError;
import com.atlassian.confluence.internal.index.status.ReIndexJobManagerInternal;
import com.atlassian.confluence.internal.index.status.ReIndexJobPersister;
import com.atlassian.confluence.internal.search.IncrementalIndexManager;
import com.atlassian.confluence.search.IndexManager;
import com.atlassian.confluence.search.ReIndexOption;
import com.atlassian.confluence.search.SearchPlatformConfig;
import com.atlassian.confluence.util.DefaultProgress;
import com.atlassian.confluence.util.Progress;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.unit.DataSize;

public class DefaultReIndexJobManager
implements ReIndexJobManagerInternal {
    private static final Logger log = LoggerFactory.getLogger(DefaultReIndexJobManager.class);
    static final String INDEX_REBUILD_MONITORING_JOB_KEY_ID = "IndexRebuildMonitoring";
    private static final long JOB_PERSISTER_LOCK_ACQUIRE_TIMEOUT_MS = Long.getLong("confluence.reindex.persister.lock.acquire.timeout.ms", 10000L);
    private static final long INDEX_REBUILD_MONITORING_INTERVAL_MS = Long.getLong("confluence.reindex.status.monitoring.interval.ms", 3000L);
    private final ReIndexJobPersister persister;
    private final EventPublisher eventPublisher;
    private final SchedulerService schedulerService;
    private final ClusterManager clusterManager;
    private final ClusterLockService clusterLockService;
    private final DarkFeatureManager darkFeatureManager;
    private final SystemMaintenanceTaskQueue systemMaintenanceTaskQueue;
    private volatile Progress legacyIndexRebuildProgress;
    private final SearchPlatformConfig searchPlatformConfig;
    private final IncrementalIndexManager contentIndexManager;
    private final IncrementalIndexManager changeIndexManager;
    private final IndexManager indexManager;

    @VisibleForTesting
    DefaultReIndexJobManager(ReIndexJobPersister persister, EventPublisher eventPublisher, SchedulerService schedulerService, ClusterManager clusterManager, ClusterLockService clusterLockService, DarkFeatureManager darkFeatureManager, SystemMaintenanceTaskQueue systemMaintenanceTaskQueue, SearchPlatformConfig searchPlatformConfig, IncrementalIndexManager contentIndexManager, IncrementalIndexManager changeIndexManager, IndexManager indexManager) {
        this.persister = Objects.requireNonNull(persister);
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
        this.schedulerService = Objects.requireNonNull(schedulerService);
        this.clusterManager = Objects.requireNonNull(clusterManager);
        this.clusterLockService = Objects.requireNonNull(clusterLockService);
        this.darkFeatureManager = Objects.requireNonNull(darkFeatureManager);
        this.systemMaintenanceTaskQueue = Objects.requireNonNull(systemMaintenanceTaskQueue);
        this.searchPlatformConfig = Objects.requireNonNull(searchPlatformConfig);
        this.contentIndexManager = Objects.requireNonNull(contentIndexManager);
        this.changeIndexManager = Objects.requireNonNull(changeIndexManager);
        this.indexManager = indexManager;
    }

    @PostConstruct
    public void register() {
        this.eventPublisher.register((Object)this);
        this.schedulerService.registerJobRunner(JobRunnerKey.of((String)INDEX_REBUILD_MONITORING_JOB_KEY_ID), this::monitorIndexRebuild);
    }

    @PreDestroy
    public void unregister() {
        this.eventPublisher.unregister((Object)this);
        this.schedulerService.unregisterJobRunner(JobRunnerKey.of((String)INDEX_REBUILD_MONITORING_JOB_KEY_ID));
    }

    @Override
    public Optional<ReIndexJob> getRunningOrMostRecentReIndex() {
        return this.darkFeatureManager.isEnabledForAllUsers("confluence.reindex.improvements").flatMap(enabled -> enabled != false ? this.persister.get() : Optional.empty());
    }

    @Override
    public boolean acknowledgeRunningJob() throws InterruptedException {
        if (!this.darkFeatureManager.isEnabledForAllUsers("confluence.reindex.improvements").orElse(false).booleanValue()) {
            return false;
        }
        AtomicBoolean acknowledged = new AtomicBoolean(false);
        try {
            this.updateReIndexJobIfPresent(runningJob -> {
                runningJob.setAcknowledged(true);
                acknowledged.set(true);
            });
            return acknowledged.get();
        }
        catch (TimeoutException e) {
            log.error("Timed out waiting to update running re-index job", (Throwable)e);
            return false;
        }
    }

    @Override
    public void updateReIndexJobIfPresent(Consumer<ReIndexJob> updater) throws InterruptedException, TimeoutException {
        this.executeWithClusterLock(() -> {
            Optional<ReIndexJob> reIndexJobOptional = this.persister.get();
            if (reIndexJobOptional.isPresent()) {
                ReIndexJob reIndexJob = reIndexJobOptional.get();
                updater.accept(reIndexJob);
                this.persister.saveOrUpdate(reIndexJob);
            }
        });
    }

    @Override
    public void updateReIndexJob(ReIndexJob reIndexJob) throws InterruptedException, TimeoutException {
        this.executeWithClusterLock(() -> this.persister.saveOrUpdate(reIndexJob));
    }

    @Override
    public boolean isReIndexing() {
        return this.getRunningOrMostRecentReIndex().filter(job -> !job.getStage().isFinal()).isPresent();
    }

    private void executeWithClusterLock(Runnable runnable) throws TimeoutException, InterruptedException {
        ClusterLock persisterLock = this.clusterLockService.getLockForName("confluence.rendex.job.persister.lock");
        if (persisterLock.tryLock(JOB_PERSISTER_LOCK_ACQUIRE_TIMEOUT_MS, TimeUnit.MILLISECONDS)) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                persisterLock.unlock();
            }
        } else {
            throw new TimeoutException("Cannot obtain cluster-lock to update running re-index job");
        }
    }

    @Override
    public Optional<ReIndexJob> createNewJob(List<String> spaceKeys) {
        return this.createNewJob(spaceKeys, EnumSet.noneOf(ReIndexOption.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<ReIndexJob> createNewJob(List<String> spaceKeys, EnumSet<ReIndexOption> reIndexOptions) {
        ClusterLock persisterLock = this.clusterLockService.getLockForName("confluence.rendex.job.persister.lock");
        try {
            if (!persisterLock.tryLock(JOB_PERSISTER_LOCK_ACQUIRE_TIMEOUT_MS, TimeUnit.MILLISECONDS)) return Optional.empty();
            try {
                ReIndexJob reIndexJob = this.createReIndexJob(this.getCurrentNodeId(), spaceKeys, reIndexOptions);
                if (this.needsToPropagateIndex()) {
                    ArrayList<ReIndexNodeStatus> nodeStatuses = new ArrayList<ReIndexNodeStatus>();
                    this.clusterManager.getAllNodesInformation().forEach(clusterNodeInformation -> nodeStatuses.add(new ReIndexNodeStatus(clusterNodeInformation.getAnonymizedNodeIdentifier(), ReIndexNodeStatus.State.WAITING)));
                    reIndexJob.setNodeStatuses(nodeStatuses);
                }
                if (!this.persister.saveNewUniquely(reIndexJob)) return Optional.empty();
                Optional<ReIndexJob> optional = Optional.of(reIndexJob);
                return optional;
            }
            finally {
                persisterLock.unlock();
            }
        }
        catch (InterruptedException e) {
            log.error("Could not create a new job: {}", (Object)e.getMessage());
            Thread.currentThread().interrupt();
        }
        return Optional.empty();
    }

    @Override
    public void clear() {
        this.persister.clear();
    }

    @EventListener
    public void onReIndexRequest(ReIndexRequestEvent reIndexRequestEvent) {
        this.legacyIndexRebuildProgress = new DefaultProgress(0, 0);
        this.systemMaintenanceTaskQueue.enqueue(new ReIndexMaintenanceTask(reIndexRequestEvent));
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JobRunnerKey.of((String)INDEX_REBUILD_MONITORING_JOB_KEY_ID)).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)INDEX_REBUILD_MONITORING_INTERVAL_MS, (Date)new Date()));
        try {
            this.schedulerService.scheduleJob(JobId.of((String)INDEX_REBUILD_MONITORING_JOB_KEY_ID), jobConfig);
            log.info("Scheduled a job to monitor progress of rebuilding index");
        }
        catch (SchedulerServiceException e) {
            log.error("Cannot schedule a job to monitor progress of rebuilding index", (Throwable)e);
        }
    }

    @EventListener
    public void onReIndexRequestFailed(ReIndexRequestFailedEvent reIndexRequestFailedEvent) {
        this.schedulerService.unscheduleJob(JobId.of((String)INDEX_REBUILD_MONITORING_JOB_KEY_ID));
    }

    @EventListener
    public void onIndexRebuildStarted(ReindexStartedEvent startedEvent) {
        if (this.darkFeatureManager.isEnabledForAllUsers("confluence.reindex.improvements").orElse(false).booleanValue() && ReIndexingScopeThreadLocal.currentScope() == ReIndexingScopeThreadLocal.ReIndexingScope.CLUSTER_WIDE) {
            this.indexRebuildStarted(startedEvent);
        }
    }

    @EventListener
    public void onIndexRebuildFinished(ReindexFinishedEvent reindexFinishedEvent) throws InterruptedException {
        if (this.darkFeatureManager.isEnabledForAllUsers("confluence.reindex.improvements").orElse(false).booleanValue() && ReIndexingScopeThreadLocal.currentScope() == ReIndexingScopeThreadLocal.ReIndexingScope.CLUSTER_WIDE) {
            this.indexRebuildFinished(false);
        }
    }

    @EventListener
    public void onIndexRebuildSkipped(ReindexSkippedEvent reindexSkippedEvent) throws InterruptedException {
        if (this.darkFeatureManager.isEnabledForAllUsers("confluence.reindex.improvements").orElse(false).booleanValue() && ReIndexingScopeThreadLocal.currentScope() == ReIndexingScopeThreadLocal.ReIndexingScope.CLUSTER_WIDE) {
            this.indexRebuildFinished(true);
        }
    }

    @EventListener
    public void onRestoreIndexSnapshotStartedEvent(RestoreIndexSnapshotStartedEvent ignored) throws InterruptedException {
        if (this.darkFeatureManager.isEnabledForAllUsers("confluence.reindex.improvements").orElse(false).booleanValue()) {
            this.restoreIndexSnapshotStarted();
        }
    }

    @EventListener
    public void onIndexSnapshotCreationFailedEvent(IndexSnapshotCreationFailedEvent failedEvent) throws InterruptedException {
        if (this.darkFeatureManager.isEnabledForAllUsers("confluence.reindex.improvements").orElse(false).booleanValue()) {
            this.createIndexSnapshotFailed(failedEvent.getError());
        }
    }

    @EventListener
    public void onIndexSnapshotCreationSuccessfulEvent(IndexSnapshotCreationSuccessfulEvent successfulEvent) throws InterruptedException {
        if (this.darkFeatureManager.isEnabledForAllUsers("confluence.reindex.improvements").orElse(false).booleanValue()) {
            this.createIndexSnapshotSuccessful(successfulEvent.getIndexJournalEntryIdMap());
        }
    }

    @EventListener
    public void onIndexSnapshotRestoredSuccessfullyEvent(IndexSnapshotRestoredSuccessfullyEvent indexSnapshotRestoredSuccessfullyEvent) throws InterruptedException {
        if (this.darkFeatureManager.isEnabledForAllUsers("confluence.reindex.improvements").orElse(false).booleanValue()) {
            this.restoreIndexSnapshotFinished(indexSnapshotRestoredSuccessfullyEvent.getNodeId(), false, null);
        }
    }

    @EventListener
    public void onIndexSnapshotRestorationFailedEvent(IndexSnapshotRestorationFailedEvent failedEvent) throws InterruptedException {
        if (this.darkFeatureManager.isEnabledForAllUsers("confluence.reindex.improvements").orElse(false).booleanValue()) {
            this.restoreIndexSnapshotFinished(failedEvent.getNodeId(), false, failedEvent.getError());
        }
    }

    @EventListener
    public void onIndexSnapshotRestorationSkippedEvent(IndexSnapshotRestorationSkippedEvent indexSnapshotRestorationSkippedEvent) throws InterruptedException {
        if (this.darkFeatureManager.isEnabledForAllUsers("confluence.reindex.improvements").orElse(false).booleanValue()) {
            this.restoreIndexSnapshotFinished(indexSnapshotRestorationSkippedEvent.getNodeId(), true, null);
        }
    }

    @EventListener
    public void onReIndexFailedEvent(ReIndexFailedEvent reIndexFailedEvent) throws InterruptedException {
        if (this.darkFeatureManager.isEnabledForAllUsers("confluence.reindex.improvements").orElse(false).booleanValue()) {
            this.indexRebuildFailed();
        }
    }

    @EventListener
    public void onSourceNodeLeftClusterDuringPropagationEvent(SourceNodeLeftClusterDuringPropagationEvent event) throws InterruptedException {
        this.handleSourceNodeExit(event);
    }

    private void handleSourceNodeExit(SourceNodeLeftClusterDuringPropagationEvent event) throws InterruptedException {
        try {
            this.updateReIndexJobIfPresent(reIndexJob -> {
                if (reIndexJob.getStage() != ReIndexStage.PROPAGATING || !reIndexJob.getSourceNodeId().equals(event.getSourceNodeId())) {
                    log.info("Received event SourceNodeLeftClusterDuringPropagationEvent but the job stage - {} and/or source node - {} is not same as {}, {}", new Object[]{reIndexJob.getStage(), reIndexJob.getSourceNodeId(), "PROPAGATING", event.getSourceNodeId()});
                    return;
                }
                Optional<ReIndexNodeStatus> sourceNodeStatus = reIndexJob.getNodeStatuses().stream().filter(node -> node.getNodeId().equals(event.getSourceNodeId()) && node.getState() != ReIndexNodeStatus.State.UNAVAILABLE).findFirst();
                if (sourceNodeStatus.isEmpty()) {
                    log.error("Source node {} is not present in node status list of reindex job {}", (Object)event.getSourceNodeId(), (Object)reIndexJob.getId());
                    return;
                }
                switch (event.getExitAction()) {
                    case MARK_NODE_AS_UNAVAILABLE: {
                        Pair<ReIndexNodeStatus.State, ReIndexError> nodeStateAndError = this.getNodeStateAndErrorByIndexSnapshotError(false, IndexSnapshotError.UNAVAILABLE);
                        this.updateMember((ReIndexJob)reIndexJob, event.getSourceNodeId(), (ReIndexNodeStatus.State)((Object)((Object)nodeStateAndError.getLeft())), (ReIndexError)((Object)((Object)nodeStateAndError.getRight())));
                        break;
                    }
                    case MARK_JOB_AS_PROPAGATION_FAILED: {
                        Pair<ReIndexNodeStatus.State, ReIndexError> nodeStateAndError = this.getNodeStateAndErrorByIndexSnapshotError(false, IndexSnapshotError.UNAVAILABLE);
                        this.updateMember((ReIndexJob)reIndexJob, event.getSourceNodeId(), (ReIndexNodeStatus.State)((Object)((Object)nodeStateAndError.getLeft())), (ReIndexError)((Object)((Object)nodeStateAndError.getRight())));
                        this.transitionToCompleteStage((ReIndexJob)reIndexJob);
                        break;
                    }
                    case INCREMENT_RESTORE_CHECK_COUNT: {
                        if (reIndexJob.getIndexRestoreCheckCount() != event.getRestoreCheckCount()) break;
                        reIndexJob.setIndexRestoreCheckCount(event.getRestoreCheckCount() + 1);
                        break;
                    }
                }
            });
        }
        catch (TimeoutException e) {
            log.error("Cannot obtain cluster lock to update re-index status: re-index finished", (Throwable)e);
        }
    }

    private void indexRebuildStarted(ReindexStartedEvent startedEvent) {
        Progress progress = startedEvent.getProgress();
        Optional<ReIndexJob> existingJob = this.getRunningOrMostRecentReIndex().filter(job -> !job.isComplete());
        boolean isNewJobCreated = existingJob.isEmpty();
        ReIndexJob currentJob = existingJob.orElseGet(() -> this.createReIndexJob(this.getCurrentNodeId(), progress != null ? (long)progress.getTotal() : 0L, startedEvent.getSpaceKeys(), startedEvent.getOptions()));
        if (!isNewJobCreated && progress != null) {
            currentJob.getRebuildingProgress().setTotal(progress.getTotal());
        }
        if (this.needsToPropagateIndex()) {
            this.updateMember(currentJob, this.getCurrentNodeId(), ReIndexNodeStatus.State.REBUILDING);
            this.eventPublisher.publish((Object)ReIndexStartedAnalyticsEvent.newPropagationReIndexStartedEvent(currentJob.getId()));
        }
        this.persister.saveOrUpdate(currentJob);
        this.legacyIndexRebuildProgress = startedEvent.getProgress();
        if (isNewJobCreated) {
            JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JobRunnerKey.of((String)INDEX_REBUILD_MONITORING_JOB_KEY_ID)).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)INDEX_REBUILD_MONITORING_INTERVAL_MS, (Date)new Date()));
            try {
                this.schedulerService.scheduleJob(JobId.of((String)INDEX_REBUILD_MONITORING_JOB_KEY_ID), jobConfig);
                log.info("Scheduled a job to monitor progress of rebuilding index");
            }
            catch (SchedulerServiceException e) {
                log.error("Cannot schedule a job to monitor progress of rebuilding index", (Throwable)e);
            }
        }
    }

    private void indexRebuildFinished(boolean isSkipped) throws InterruptedException {
        this.schedulerService.unscheduleJob(JobId.of((String)INDEX_REBUILD_MONITORING_JOB_KEY_ID));
        try {
            this.updateReIndexJobIfPresent(reIndexJob -> {
                this.updateReIndexJobOnReindexFinished((ReIndexJob)reIndexJob, isSkipped);
                long indexingTimeSecs = reIndexJob.getStartTime().until(Instant.now(), ChronoUnit.SECONDS);
                this.eventPublisher.publish((Object)ReIndexFinishedAnalyticsEvent.newPropagationReIndexFinishedEvent(reIndexJob.getId(), indexingTimeSecs, reIndexJob.getNodeStatuses().size(), DataSize.ofBytes((long)this.contentIndexManager.getSizeInBytes()).toMegabytes(), DataSize.ofBytes((long)this.changeIndexManager.getSizeInBytes()).toMegabytes(), this.searchPlatformConfig.searchPlatform()));
            });
        }
        catch (TimeoutException e) {
            log.error("Cannot obtain cluster lock to update re-index status: re-index finished", (Throwable)e);
        }
    }

    private void indexRebuildFailed() throws InterruptedException {
        this.schedulerService.unscheduleJob(JobId.of((String)INDEX_REBUILD_MONITORING_JOB_KEY_ID));
        try {
            this.updateReIndexJobIfPresent(this::updateReIndexJobOnReindexFailed);
        }
        catch (TimeoutException e) {
            log.error("Cannot obtain cluster lock to update re-index status: re-index failed", (Throwable)e);
        }
    }

    private void updateReIndexJobOnReindexFinished(ReIndexJob reIndexJob, boolean isSkipped) {
        ReIndexJob.Progress currentProgress = reIndexJob.getRebuildingProgress();
        this.updateRebuildingProgress(reIndexJob, currentProgress.getTotal(), currentProgress.getTotal());
        if (!this.clusterManager.isClustered()) {
            this.transitionToCompleteStage(reIndexJob);
            return;
        }
        ClusterNodeInformation thisNodeInformation = this.clusterManager.getThisNodeInformation();
        String currentNodeId = thisNodeInformation != null ? thisNodeInformation.getAnonymizedNodeIdentifier() : "";
        this.updateMember(reIndexJob, currentNodeId, isSkipped ? ReIndexNodeStatus.State.REBUILD_SKIPPED : ReIndexNodeStatus.State.REBUILD_COMPLETE);
        int numberOfNodes = reIndexJob.getNodeStatuses().size();
        if (numberOfNodes <= 1) {
            this.transitionToCompleteStage(reIndexJob);
            return;
        }
        if (reIndexJob.isSiteReindex() && !isSkipped) {
            reIndexJob.setStage(ReIndexStage.PROPAGATING);
            return;
        }
        if (this.allOtherNodesComplete(reIndexJob, currentNodeId)) {
            this.transitionToCompleteStage(reIndexJob);
        }
    }

    private void updateReIndexJobOnReindexFailed(ReIndexJob reIndexJob) {
        ReIndexJob.Progress currentProgress = reIndexJob.getRebuildingProgress();
        this.updateRebuildingProgress(reIndexJob, currentProgress.getTotal(), currentProgress.getTotal());
        boolean shouldTransition = true;
        if (this.clusterManager.isClustered()) {
            ClusterNodeInformation thisNodeInformation = this.clusterManager.getThisNodeInformation();
            String currentNodeId = thisNodeInformation != null ? thisNodeInformation.getAnonymizedNodeIdentifier() : "";
            this.updateMember(reIndexJob, currentNodeId, ReIndexNodeStatus.State.REBUILD_FAILED, ReIndexError.UNKNOWN);
            if (this.needsToPropagateIndex()) {
                if (reIndexJob.isSiteReindex()) {
                    reIndexJob.getNodeStatuses().stream().filter(reIndexNodeStatus -> !reIndexNodeStatus.getNodeId().equals(currentNodeId)).forEach(nodeStatus -> this.updateMember(reIndexJob, nodeStatus.getNodeId(), ReIndexNodeStatus.State.REBUILD_FAILED, ReIndexError.UNKNOWN));
                } else {
                    shouldTransition = this.allOtherNodesComplete(reIndexJob, currentNodeId);
                }
            }
        }
        if (shouldTransition) {
            this.transitionToFailedStage(reIndexJob);
        }
    }

    private boolean allOtherNodesComplete(ReIndexJob reIndexJob, String currentNodeId) {
        return reIndexJob.getNodeStatuses().stream().noneMatch(reIndexNodeStatus -> !reIndexNodeStatus.isFinished() && !reIndexNodeStatus.getNodeId().equals(currentNodeId));
    }

    private void transitionToCompleteStage(ReIndexJob reIndexJob) {
        AtomicReference<ReIndexStage> finalStage = new AtomicReference<ReIndexStage>(ReIndexStage.COMPLETE);
        reIndexJob.setFinishTime(Instant.now());
        Collection nodeStatuses = CollectionUtils.emptyIfNull(reIndexJob.getNodeStatuses());
        nodeStatuses.stream().filter(ReIndexNodeStatus::isFailed).findFirst().ifPresent(ignored -> finalStage.set(reIndexJob.isSiteReindex() ? ReIndexStage.PROPAGATION_FAILED : ReIndexStage.REBUILD_FAILED));
        reIndexJob.setStage(finalStage.get());
        this.eventPublisher.publish((Object)new ReIndexJobFinishedEvent((Object)this, reIndexJob));
        ReindexAnalyticsEventPublishingHelper.publishReindexingAnalyticsEvent(this.eventPublisher, reIndexJob);
    }

    private void transitionToFailedStage(ReIndexJob reIndexJob) {
        reIndexJob.setFinishTime(Instant.now());
        reIndexJob.setStage(ReIndexStage.REBUILD_FAILED);
        this.eventPublisher.publish((Object)new ReIndexJobFinishedEvent((Object)this, reIndexJob));
        ReindexAnalyticsEventPublishingHelper.publishReindexingAnalyticsEvent(this.eventPublisher, reIndexJob);
    }

    private void createIndexSnapshotFailed(IndexSnapshotError error) throws InterruptedException {
        try {
            this.updateReIndexJobIfPresent(reIndexJob -> {
                ClusterNodeInformation thisNodeInformation = this.clusterManager.getThisNodeInformation();
                if (thisNodeInformation == null) {
                    log.error("Current node information is not found. The node could have dropped out of the cluster");
                    return;
                }
                this.updateMember((ReIndexJob)reIndexJob, thisNodeInformation.getAnonymizedNodeIdentifier(), ReIndexNodeStatus.State.PROPAGATION_FAIL, error.toReIndexError());
                reIndexJob.setStage(ReIndexStage.PROPAGATION_FAILED);
            });
        }
        catch (TimeoutException e) {
            log.error("Cannot obtain cluster lock to update re-index status: propagation finished", (Throwable)e);
        }
    }

    private void createIndexSnapshotSuccessful(Map<String, Long> indexJournalEntryIdMap) throws InterruptedException {
        if (indexJournalEntryIdMap == null || indexJournalEntryIdMap.isEmpty()) {
            log.error("received an empty indexJournalEntryIdMap, can not store the mapping in reindexJob");
            return;
        }
        try {
            this.updateReIndexJobIfPresent(reIndexJob -> reIndexJob.setIndexJournalEntryIdMap(indexJournalEntryIdMap));
        }
        catch (TimeoutException e) {
            log.error("Cannot obtain cluster lock to update re-index status: propagation finished", (Throwable)e);
        }
    }

    private void restoreIndexSnapshotStarted() throws InterruptedException {
        try {
            this.updateReIndexJobIfPresent(reIndexJob -> this.updateMember((ReIndexJob)reIndexJob, this.clusterManager.getThisNodeInformation().getAnonymizedNodeIdentifier(), ReIndexNodeStatus.State.PROPAGATING));
        }
        catch (TimeoutException e) {
            log.error("Cannot obtain cluster lock to update re-index status: propagation started", (Throwable)e);
        }
    }

    private void restoreIndexSnapshotFinished(String nodeId, boolean isSkipped, @Nullable IndexSnapshotError indexSnapshotError) throws InterruptedException {
        try {
            this.updateReIndexJobIfPresent(reIndexJob -> {
                if (!this.shouldUpdateReindexJobOnIndexSnapshotRestorationFailed(nodeId, (ReIndexJob)reIndexJob, indexSnapshotError)) {
                    return;
                }
                Pair<ReIndexNodeStatus.State, ReIndexError> nodeStateAndError = this.getNodeStateAndErrorByIndexSnapshotError(isSkipped, indexSnapshotError);
                this.updateMember((ReIndexJob)reIndexJob, nodeId, (ReIndexNodeStatus.State)((Object)((Object)nodeStateAndError.getLeft())), (ReIndexError)((Object)((Object)nodeStateAndError.getRight())));
                ReIndexJob.Progress currentProgress = reIndexJob.getPropagatingProgress();
                ReIndexJob.Progress updatedProgress = new ReIndexJob.Progress(currentProgress.getProcessed() + 1L, currentProgress.getTotal());
                reIndexJob.setPropagatingProgress(updatedProgress);
                if (updatedProgress.getProcessed() == updatedProgress.getTotal()) {
                    this.transitionToCompleteStage((ReIndexJob)reIndexJob);
                }
            });
        }
        catch (TimeoutException e) {
            log.error("Cannot obtain cluster lock to update re-index status: propagation finished", (Throwable)e);
        }
    }

    private boolean shouldUpdateReindexJobOnIndexSnapshotRestorationFailed(String sourceNodeId, ReIndexJob reIndexJob, @Nullable IndexSnapshotError indexSnapshotError) {
        Optional<ReIndexNodeStatus> nodeStatus;
        return indexSnapshotError != IndexSnapshotError.UNAVAILABLE || !(nodeStatus = reIndexJob.getNodeStatuses().stream().filter(node -> sourceNodeId.equals(node.getNodeId())).findFirst()).isPresent() || nodeStatus.get().getState() != ReIndexNodeStatus.State.UNAVAILABLE;
    }

    private Pair<ReIndexNodeStatus.State, ReIndexError> getNodeStateAndErrorByIndexSnapshotError(boolean isSkipped, IndexSnapshotError indexSnapshotError) {
        if (indexSnapshotError == null) {
            return Pair.of((Object)((Object)(isSkipped ? ReIndexNodeStatus.State.PROPAGATION_SKIPPED : ReIndexNodeStatus.State.PROPAGATION_COMPLETE)), null);
        }
        ReIndexNodeStatus.State state = indexSnapshotError == IndexSnapshotError.UNAVAILABLE ? ReIndexNodeStatus.State.UNAVAILABLE : ReIndexNodeStatus.State.PROPAGATION_FAIL;
        return Pair.of((Object)((Object)state), (Object)((Object)indexSnapshotError.toReIndexError()));
    }

    private void updateMember(ReIndexJob job, String nodeId, ReIndexNodeStatus.State newState) {
        this.updateMember(job, nodeId, newState, null);
    }

    private void updateMember(ReIndexJob job, String nodeId, ReIndexNodeStatus.State newState, @Nullable ReIndexError error) {
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            return;
        }
        Optional<ReIndexNodeStatus> nodeStatus = job.getNodeStatuses().stream().filter(reIndexNodeStatus -> nodeId.equals(reIndexNodeStatus.getNodeId())).findFirst();
        if (nodeStatus.isPresent()) {
            ReIndexNodeStatus nodeState = nodeStatus.get();
            nodeState.setState(newState);
            nodeState.setError(error);
        } else {
            job.getNodeStatuses().add(new ReIndexNodeStatus(nodeId, newState, error));
        }
        if (newState.isFinished()) {
            ReindexAnalyticsEventPublishingHelper.publishSpaceNodeAnalyticsEvent(this.eventPublisher, job, nodeId);
        }
    }

    @VisibleForTesting
    JobRunnerResponse monitorIndexRebuild(JobRunnerRequest ignored) {
        try {
            this.updateReIndexJobIfPresent(job -> {
                if (this.legacyIndexRebuildProgress != null) {
                    this.updateRebuildingProgress((ReIndexJob)job);
                    job.setLastRebuildingUpdate(Instant.now());
                }
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return JobRunnerResponse.aborted((String)"Interrupted");
        }
        catch (TimeoutException e) {
            log.error("Cannot obtain cluster lock to update re-index job", (Throwable)e);
            return JobRunnerResponse.failed((Throwable)e);
        }
        return JobRunnerResponse.success();
    }

    private void updateRebuildingProgress(ReIndexJob job) {
        this.updateRebuildingProgress(job, this.legacyIndexRebuildProgress.getCount(), this.legacyIndexRebuildProgress.getTotal());
    }

    private void updateRebuildingProgress(ReIndexJob job, long processed, long total) {
        if (job.isSiteReindex() || this.isStandaloneOrSingleNodeClusterWhenReindexingStarted(job)) {
            job.setRebuildingProgress(new ReIndexJob.Progress(processed, total));
        } else {
            this.updateCurrentNodeProgress(job, processed, total);
            long processedOnAverage = job.getNodeStatuses().stream().map(nodeStatus -> nodeStatus.getProgress().getProcessed()).mapToLong(Long::longValue).sum() / (long)job.getNodeStatuses().size();
            job.setRebuildingProgress(new ReIndexJob.Progress(processedOnAverage, total));
        }
    }

    private void updateCurrentNodeProgress(ReIndexJob job, long processed, long total) {
        ClusterNodeInformation currentNodeInformation = this.clusterManager.getThisNodeInformation();
        if (currentNodeInformation == null) {
            log.error("Could not find current node's information");
            return;
        }
        String nodeId = currentNodeInformation.getAnonymizedNodeIdentifier();
        Optional<ReIndexNodeStatus> currentNodeStatusOptional = job.getNodeStatuses().stream().filter(nodeStatus -> nodeId.equals(nodeStatus.getNodeId())).findFirst();
        currentNodeStatusOptional.ifPresent(currentNodeStatus -> currentNodeStatus.setProgress(new ReIndexJob.Progress(processed, total)));
    }

    private boolean isStandaloneOrSingleNodeClusterWhenReindexingStarted(ReIndexJob job) {
        return !this.clusterManager.isClustered() || CollectionUtils.size(job.getNodeStatuses()) <= 1 || this.clusterManager.getThisNodeInformation() == null;
    }

    private boolean needsToPropagateIndex() {
        return !this.searchPlatformConfig.isSharedIndex() && this.clusterManager.isClustered();
    }

    private ReIndexJob createReIndexJob(String sourceNodeId, List<String> spaceKeys, EnumSet<ReIndexOption> reIndexOptions) {
        return this.createReIndexJob(sourceNodeId, 0L, spaceKeys, reIndexOptions);
    }

    private ReIndexJob createReIndexJob(String sourceNodeId, long totalCount, List<String> spaceKeys, EnumSet<ReIndexOption> reIndexOptions) {
        ReIndexJob job = new ReIndexJob(Instant.now(), totalCount, spaceKeys);
        job.setReIndexOptions(reIndexOptions);
        job.setSourceNodeId(sourceNodeId);
        boolean needToPropagateSnapshot = job.isSiteReindex() && this.needsToPropagateIndex();
        ReIndexJob.Progress propagatingProgress = needToPropagateSnapshot ? new ReIndexJob.Progress(0L, (long)this.clusterManager.getClusterInformation().getMemberCount() - 1L) : new ReIndexJob.Progress(0L, 0L);
        job.setPropagatingProgress(propagatingProgress);
        return job;
    }

    private String getCurrentNodeId() {
        ClusterNodeInformation nodeInformation;
        if (this.clusterManager != null && (nodeInformation = this.clusterManager.getThisNodeInformation()) != null) {
            return nodeInformation.getAnonymizedNodeIdentifier();
        }
        return "";
    }
}

