/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.index.v2;

import com.atlassian.annotations.Internal;
import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.Versioned;
import com.atlassian.confluence.internal.index.lucene.LuceneChangeExtractor;
import com.atlassian.confluence.internal.index.v2.Extractor2DocumentBuilder;
import com.atlassian.confluence.internal.search.ChangeDocumentIndexPolicy;
import com.atlassian.confluence.internal.search.extractor2.Extractor2Provider;
import com.atlassian.confluence.search.v2.AtlassianDocument;
import com.atlassian.confluence.search.v2.AtlassianDocumentBuilder;
import com.atlassian.confluence.search.v2.lucene.SearchIndex;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import java.util.Collections;

@Internal
public class AtlassianChangeDocumentBuilder
implements AtlassianDocumentBuilder<Searchable> {
    private final AtlassianDocumentBuilder<Searchable> latestVersionedDelegate = new Extractor2DocumentBuilder<Searchable>(() -> extractor2Provider.get(SearchIndex.CHANGE, true), Collections.emptyList());
    private final AtlassianDocumentBuilder<Searchable> nonLatestVersionedDelegate = new Extractor2DocumentBuilder<Searchable>(() -> extractor2Provider.get(SearchIndex.CHANGE, false), Collections.emptyList());

    public AtlassianChangeDocumentBuilder(Extractor2Provider extractor2Provider) {
    }

    @Override
    public AtlassianDocument build(Searchable searchable) {
        try (Ticker ignored = Timers.start((String)"ChangeDocumentBuilder.build");){
            ChangeDocumentIndexPolicy.PolicyCheckResult policyCheckResult = ChangeDocumentIndexPolicy.buildFor(searchable);
            if (policyCheckResult.passed()) {
                AtlassianDocument completeDocument = this.nonLatestVersionedDelegate.build(searchable);
                Versioned latestVersion = ((Versioned)searchable).getLatestVersion();
                Searchable latestSearchable = (Searchable)latestVersion;
                completeDocument.addFields(this.latestVersionedDelegate.build(latestSearchable).getFields());
                completeDocument.setId(completeDocument.getValue(LuceneChangeExtractor.Mappings.CHANGE_DOCUMENT_AND_AUTHOR_ID.getName()).orElse(null));
                AtlassianDocument atlassianDocument = completeDocument;
                return atlassianDocument;
            }
            throw new UnsupportedOperationException(policyCheckResult.getErrorMessage());
        }
    }
}

