/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.index.v2;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.internal.index.v2.BulkExtractor2Adapter;
import com.atlassian.confluence.internal.index.v2.DefaultExtractorContext;
import com.atlassian.confluence.internal.index.v2.Extractor2DocumentBuilder;
import com.atlassian.confluence.internal.index.v2.ExtractorContextPreProcessor;
import com.atlassian.confluence.internal.search.extractor2.BulkExtractorProvider;
import com.atlassian.confluence.search.v2.AtlassianDocument;
import com.atlassian.confluence.search.v2.AtlassianDocumentBuilder;
import com.atlassian.confluence.search.v2.extractor.BulkExtractor;
import com.atlassian.confluence.search.v2.lucene.SearchIndex;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlassianSelectiveFieldsDocumentBuilder
implements AtlassianDocumentBuilder<Searchable> {
    private static final Logger log = LoggerFactory.getLogger(AtlassianSelectiveFieldsDocumentBuilder.class);
    private final BulkExtractorProvider bulkExtractorProvider;
    private final List<ExtractorContextPreProcessor> contextPreProcessorList;
    private final DefaultExtractorContext extractorContext;
    private final SearchIndex searchIndex;

    public AtlassianSelectiveFieldsDocumentBuilder(BulkExtractorProvider bulkExtractorProvider, List<ExtractorContextPreProcessor> contextPreProcessorList, DefaultExtractorContext extractorContext, SearchIndex searchIndex) {
        this.bulkExtractorProvider = bulkExtractorProvider;
        this.contextPreProcessorList = contextPreProcessorList != null ? contextPreProcessorList : Collections.emptyList();
        this.extractorContext = extractorContext;
        this.searchIndex = searchIndex;
    }

    @Override
    public AtlassianDocument build(Searchable searchable) {
        Extractor2DocumentBuilder<Searchable> bulkExtractionDelegate = new Extractor2DocumentBuilder<Searchable>(() -> this.bulkExtractorProvider.findBulkExtractors(this.searchIndex).stream().filter(this.bulkExtractorFilter(searchable, this.contextPreProcessorList, "bulkExtractorClasses")).map(extractor -> extractor).map(BulkExtractor2Adapter::new).collect(Collectors.toList()), this.contextPreProcessorList);
        try (Ticker ignored = Timers.start((String)"AtlassianSelectiveFieldsDocumentBuilder.build");){
            AtlassianDocument atlassianDocument = bulkExtractionDelegate.build(searchable);
            return atlassianDocument;
        }
    }

    private Predicate<? super BulkExtractor<?>> bulkExtractorFilter(Searchable searchable, List<ExtractorContextPreProcessor> contextPreProcessorList, String attributeName) {
        HashSet allExtractorClasses = new HashSet();
        for (ExtractorContextPreProcessor extractorContextPreProcessor : contextPreProcessorList) {
            extractorContextPreProcessor.process(searchable, this.extractorContext.getContextWriter());
            Set extractorClasses = this.extractorContext.getAttribute(attributeName).orElse(Collections.emptySet());
            allExtractorClasses.addAll(extractorClasses);
        }
        return extractor -> allExtractorClasses.contains(extractor.getClass());
    }
}

