/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.index.v2;

import com.atlassian.confluence.plugins.index.api.Extractor2;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.atlassian.confluence.search.v2.extractor.BulkExtractor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BulkExtractor2Adapter
implements Extractor2 {
    private static final Logger log = LoggerFactory.getLogger(BulkExtractor2Adapter.class);
    private final BulkExtractor<Object> bulkExtractor;

    BulkExtractor2Adapter(BulkExtractor<Object> bulkExtractor) {
        this.bulkExtractor = bulkExtractor;
    }

    @Override
    public @NonNull Collection<FieldDescriptor> extractFields(@NonNull Object searchable) {
        if (this.bulkExtractor.canHandle(searchable.getClass())) {
            ArrayList<FieldDescriptor> fieldDescriptors = new ArrayList<FieldDescriptor>();
            try {
                this.bulkExtractor.extractAll(Collections.singleton(searchable), searchable.getClass(), (v, fieldDescriptor) -> fieldDescriptors.add((FieldDescriptor)fieldDescriptor));
            }
            catch (RuntimeException e) {
                log.error("Failed to extract fields from {}", this.bulkExtractor, (Object)e);
            }
            return fieldDescriptors;
        }
        return Collections.emptySet();
    }

    @Override
    public @Nullable StringBuilder extractText(Object searchable) {
        return null;
    }
}

