/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.index.v2;

import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.atlassian.confluence.search.v2.AtlassianDocument;
import com.atlassian.confluence.search.v2.AtlassianDocumentBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class MergingAtlassianDocumentBuilder<T>
implements AtlassianDocumentBuilder<T> {
    private final Collection<AtlassianDocumentBuilder<T>> delegates;

    public MergingAtlassianDocumentBuilder(Collection<AtlassianDocumentBuilder<T>> delegates) {
        this.delegates = delegates;
    }

    @Override
    public AtlassianDocument build(T searchable) {
        List<AtlassianDocument> documents = this.buildDocuments(searchable);
        AtlassianDocument result = new AtlassianDocument(MergingAtlassianDocumentBuilder.mergeFields(documents));
        result.setId(this.mergeId(documents));
        return result;
    }

    private List<AtlassianDocument> buildDocuments(T searchable) {
        return this.delegates.stream().map(delegate -> delegate.build(searchable)).collect(Collectors.toList());
    }

    private static List<FieldDescriptor> mergeFields(List<AtlassianDocument> documents) {
        return documents.stream().flatMap(d -> d.getFields().stream()).collect(Collectors.toList());
    }

    private String mergeId(List<AtlassianDocument> documents) {
        Set ids = documents.stream().map(AtlassianDocument::getId).filter(Objects::nonNull).collect(Collectors.toSet());
        if (ids.size() > 1) {
            throw new IllegalArgumentException("Failed to merge documents because they contain multiple IDs");
        }
        return ids.stream().findFirst().orElse(null);
    }
}

