/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.index.v2.impl;

import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.BodyType;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.internal.index.v2.ExtractorContextPreProcessor;
import com.atlassian.confluence.internal.index.v2.ExtractorContextWriter;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.renderer.v2.WikiMarkupParser;
import com.atlassian.renderer.v2.components.MacroTag;
import com.atlassian.renderer.v2.components.WikiContentHandler;
import com.atlassian.renderer.v2.macro.MacroManager;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroDefinitionExtractorContextPreprocessor
implements ExtractorContextPreProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MacroDefinitionExtractorContextPreprocessor.class);
    private final XhtmlContent xhtmlContent;
    private final com.atlassian.confluence.renderer.MacroManager macroManager;

    public MacroDefinitionExtractorContextPreprocessor(XhtmlContent xhtmlContent, com.atlassian.confluence.renderer.MacroManager macroManager) {
        this.macroManager = macroManager;
        this.xhtmlContent = xhtmlContent;
    }

    @Override
    public void process(Object searchable, ExtractorContextWriter extractorContextWriter) {
        ArrayList macroDefinitions = new ArrayList();
        if (searchable instanceof Page || searchable instanceof BlogPost || searchable instanceof Comment) {
            logger.debug("Extracting macro definition for content entity object {}", searchable);
            this.extractMacros((ContentEntityObject)searchable, macroDefinitions::add);
        }
        logger.debug("Setting up macro definitions for {} with {} macros", searchable, (Object)macroDefinitions.size());
        extractorContextWriter.setAttribute("macro_definitions", macroDefinitions);
    }

    void extractMacros(ContentEntityObject searchable, Consumer<MacroDefinition> collector) {
        String bodyAsString = searchable.getBodyAsString();
        BodyType bodyType = searchable.getBodyContent().getBodyType();
        if (bodyType != null && StringUtils.isNotBlank((CharSequence)bodyAsString)) {
            if (bodyType.equals(BodyType.WIKI)) {
                this.extractWikiMacros(bodyAsString, collector);
            } else if (bodyType.equals(BodyType.XHTML)) {
                this.extractXhtmlMacros(searchable, collector);
            } else {
                logger.debug("Skipping macro extraction for entity '{}' of body type '{}'", (Object)searchable.getId(), (Object)bodyType);
            }
        } else {
            logger.debug("Skipping macro extraction for entity '{}' as bodyType is null", (Object)searchable.getId());
        }
    }

    private void extractWikiMacros(String bodyContents, final Consumer<MacroDefinition> collector) {
        if (bodyContents == null) {
            return;
        }
        WikiMarkupParser wikiParser = new WikiMarkupParser((MacroManager)this.macroManager, new WikiContentHandler(){

            public void handleMacro(StringBuffer buffer, MacroTag macroTag, String body) {
                collector.accept(MacroDefinition.builder().withName(macroTag.command).withStorageVersion("0").build());
                MacroDefinitionExtractorContextPreprocessor.this.extractWikiMacros(body, collector);
            }

            public void handleText(StringBuffer buffer, String s) {
            }
        });
        wikiParser.parse(bodyContents);
    }

    private void extractXhtmlMacros(ContentEntityObject searchable, Consumer<MacroDefinition> collector) {
        DefaultConversionContext context = new DefaultConversionContext(searchable.toPageContext());
        try {
            this.xhtmlContent.handleMacroDefinitions(searchable.getBodyAsString(), context, macroDefinition -> {
                collector.accept(macroDefinition);
                String macroName = macroDefinition.getName();
                if (macroName.equals("unmigrated-wiki-markup") || macroName.equals("unmigrated-inline-wiki-markup")) {
                    this.extractWikiMacros(macroDefinition.getBodyText(), collector);
                }
            });
        }
        catch (XhtmlException ex) {
            logger.warn("Failed to extract macro usages on entity [{}] : {}", (Object)searchable.getId(), (Object)ex.getMessage());
            logger.debug("Failed to extract macro usages on entity [{}] : {}", (Object)searchable.getId(), (Object)ex);
        }
    }
}

