/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.license;

import com.atlassian.confluence.event.events.admin.LicenceUpdatedEvent;
import com.atlassian.confluence.internal.license.EnterpriseFeatureFlag;
import com.atlassian.confluence.license.LicenseService;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import io.atlassian.util.concurrent.Lazy;
import io.atlassian.util.concurrent.ResettableLazyReference;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.Objects;

public class LicenseBasedCachingEnterpriseFeatureFlag
implements EnterpriseFeatureFlag {
    private final EventPublisher eventPublisher;
    private final ResettableLazyReference<Boolean> isDcOrExempt;

    public LicenseBasedCachingEnterpriseFeatureFlag(LicenseService licenseService, EventPublisher eventPublisher) {
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
        this.isDcOrExempt = Lazy.resettable(() -> ((LicenseService)licenseService).isLicensedForDataCenterOrExempt());
    }

    @PostConstruct
    public void register() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void unregister() {
        this.eventPublisher.unregister((Object)this);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)this.isDcOrExempt.get();
    }

    @EventListener
    public void onLicenseUpdatedEvent(LicenceUpdatedEvent ignored) {
        this.isDcOrExempt.reset();
    }
}

