/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.persistence;

import com.atlassian.confluence.core.persistence.confluence.StaleObjectStateException;
import com.atlassian.confluence.impl.spring.FirstOnStackRetryPolicy;
import com.atlassian.confluence.impl.spring.LoggingRetryListener;
import com.atlassian.confluence.rpc.RemoteException;
import org.hibernate.StaleStateException;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.retry.RetryOperations;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.interceptor.RetryOperationsInterceptor;
import org.springframework.retry.policy.CompositeRetryPolicy;
import org.springframework.retry.policy.MaxAttemptsRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.transaction.UnexpectedRollbackException;

@Configuration
public class TransactionRetryInterceptorConfig {
    private static final RetryPolicy OUTERMOST_TRANSACTION_POLICY = new FirstOnStackRetryPolicy();
    private static final int MAX_TRANSACTION_ATTEMPTS = Integer.getInteger("confluence.transaction.retry.maxAttempts", 2);

    @Bean
    RetryOperationsInterceptor transactionRetryInterceptor() {
        RetryOperationsInterceptor interceptor = new RetryOperationsInterceptor();
        interceptor.setRetryOperations((RetryOperations)TransactionRetryInterceptorConfig.transactionRetryTemplate());
        return interceptor;
    }

    public static RetryTemplate transactionRetryTemplate() {
        CompositeRetryPolicy retryPolicy = new CompositeRetryPolicy();
        retryPolicy.setPolicies(new RetryPolicy[]{OUTERMOST_TRANSACTION_POLICY, new MaxAttemptsRetryPolicy(MAX_TRANSACTION_ATTEMPTS)});
        return RetryTemplate.builder().noBackoff().withListener(LoggingRetryListener.INSTANCE).retryOn(OptimisticLockingFailureException.class).retryOn(StaleObjectStateException.class).retryOn(StaleStateException.class).retryOn(RemoteException.class).retryOn(UnexpectedRollbackException.class).traversingCauses().customPolicy((RetryPolicy)retryPolicy).build();
    }
}

