/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.relations;

import com.atlassian.confluence.content.CustomContentEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.core.bean.EntityObject;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public enum RelatableEntityTypeEnum {
    PAGE(Page.class),
    COMMENT(Comment.class),
    BLOG(BlogPost.class),
    ATTACHMENT(Attachment.class),
    USER(ConfluenceUser.class),
    SPACE(Space.class),
    DRAFT(Draft.class),
    CUSTOM(CustomContentEntityObject.class);

    private final Class<? extends EntityObject> typeClass;

    private RelatableEntityTypeEnum(Class typeClass) {
        this.typeClass = typeClass;
    }

    public Class<? extends EntityObject> getType() {
        return this.typeClass;
    }

    public String getTypeName() {
        return this.typeClass.getName();
    }

    public static RelatableEntityTypeEnum getByContentEntityObject(ContentEntityObject object) {
        ContentEntityObject contentEntityObject = object;
        Objects.requireNonNull(contentEntityObject);
        ContentEntityObject contentEntityObject2 = contentEntityObject;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Page.class, SpaceDescription.class, BlogPost.class, Attachment.class, Comment.class, Draft.class, CustomContentEntityObject.class}, (Object)contentEntityObject2, n)) {
            case 0 -> {
                Page ignored = (Page)contentEntityObject2;
                yield PAGE;
            }
            case 1 -> {
                SpaceDescription ignored = (SpaceDescription)contentEntityObject2;
                yield SPACE;
            }
            case 2 -> {
                BlogPost ignored = (BlogPost)contentEntityObject2;
                yield BLOG;
            }
            case 3 -> {
                Attachment ignored = (Attachment)contentEntityObject2;
                yield ATTACHMENT;
            }
            case 4 -> {
                Comment ignored = (Comment)contentEntityObject2;
                yield COMMENT;
            }
            case 5 -> {
                Draft ignored = (Draft)contentEntityObject2;
                yield DRAFT;
            }
            case 6 -> {
                CustomContentEntityObject ignored = (CustomContentEntityObject)contentEntityObject2;
                yield CUSTOM;
            }
            default -> throw new IllegalArgumentException(String.valueOf(object) + " is not supported");
        };
    }

    public static RelatableEntityTypeEnum getByContentType(ContentTypeEnum object) {
        return switch (object) {
            case ContentTypeEnum.PAGE -> PAGE;
            case ContentTypeEnum.SPACE -> SPACE;
            case ContentTypeEnum.BLOG -> BLOG;
            case ContentTypeEnum.ATTACHMENT -> ATTACHMENT;
            case ContentTypeEnum.COMMENT -> COMMENT;
            case ContentTypeEnum.DRAFT -> DRAFT;
            case ContentTypeEnum.CUSTOM -> CUSTOM;
            default -> throw new IllegalArgumentException(String.valueOf((Object)object) + " is not supported");
        };
    }
}

