/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.relations.dao.hibernate;

import com.atlassian.confluence.api.model.relations.RelationDescriptor;
import com.atlassian.confluence.dmz.relations.RelatableEntity;
import com.atlassian.confluence.dmz.relations.dao.RelationEntity;
import com.atlassian.confluence.dmz.relations.query.RelationQuery;
import com.atlassian.confluence.internal.relations.dao.RelationDao;
import com.atlassian.confluence.internal.relations.dao.hibernate.RelationQueryHelper;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.Query;

public abstract class HibernateRelationDao<S extends RelatableEntity, T extends RelatableEntity>
implements RelationDao<S, T> {
    protected static final String SOURCE_PARAM_NAME = "source";
    protected static final String TARGET_PARAM_NAME = "target";
    protected static final String RELATION_PARAM_NAME = "relationName";
    protected static final int BATCHING_CHUNK_SIZE = 500;
    protected final SessionFactoryImplementor sessionFactory;

    public HibernateRelationDao(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public RelationEntity<S, T> createRelationEntity(S source, T target, RelationDescriptor<?, ?> relationDescriptor) {
        RelationEntity<S, T> relationEntity = this.constructRelationEntity(this.newRelationEntity(source, target), source, target, relationDescriptor);
        this.sessionFactory.getCurrentSession().save(relationEntity);
        return relationEntity;
    }

    @Override
    public void removeRelationEntity(RelationEntity<S, T> relationEntity) {
        this.sessionFactory.getCurrentSession().delete(relationEntity);
    }

    protected @NonNull List<RelationEntity<S, T>> getRelationEntities(String queryName, S source, T target, RelationDescriptor<?, ?> relationDescriptor) {
        ImmutableMap parameters = ImmutableMap.of((Object)SOURCE_PARAM_NAME, source, (Object)TARGET_PARAM_NAME, target, (Object)RELATION_PARAM_NAME, (Object)relationDescriptor.getRelationName());
        Query query = this.sessionFactory.getCurrentSession().getNamedQuery(queryName);
        RelationQueryHelper.feedQueryParameters(query, (Map<String, Object>)parameters);
        return query.list();
    }

    int getSourceOrTargetCount(RelationQuery<?> request, boolean isFetchingSources) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String queryStr = "select count(*) " + RelationQueryHelper.buildConditionalQueryFor(request, parameters, isFetchingSources);
        Query query = this.sessionFactory.getCurrentSession().createQuery(queryStr, Number.class);
        RelationQueryHelper.feedQueryParameters(query, parameters);
        return ((Number)query.getSingleResult()).intValue();
    }

    protected abstract RelationEntity<S, T> newRelationEntity(S var1, T var2);

    <X> List<X> fetchList(Class<X> resultType, String queryStr, Map<String, Object> parameters, int start, int limit) {
        Query query = this.sessionFactory.getCurrentSession().createQuery(queryStr, resultType);
        RelationQueryHelper.feedQueryParameters(query, parameters);
        return query.setFirstResult(start).setMaxResults(limit).list();
    }

    protected RelationEntity<S, T> constructRelationEntity(RelationEntity<S, T> relationEntity, S source, T target, RelationDescriptor<?, ?> relationDescriptor) {
        relationEntity.setTargetContent(target);
        relationEntity.setSourceContent(source);
        relationEntity.setRelationName(relationDescriptor.getRelationName());
        relationEntity.setCreationDate(new Date());
        relationEntity.setLastModificationDate(new Date());
        relationEntity.setCreator(AuthenticatedUserThreadLocal.get());
        relationEntity.setLastModifier(AuthenticatedUserThreadLocal.get());
        return relationEntity;
    }
}

