/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.relations.dao.hibernate;

import com.atlassian.confluence.api.model.relations.RelationDescriptor;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.persistence.schema.api.SchemaInformationService;
import com.atlassian.confluence.dmz.relations.RelatableEntity;
import com.atlassian.confluence.dmz.relations.dao.RelationEntity;
import com.atlassian.confluence.dmz.relations.query.RelationQuery;
import com.atlassian.confluence.impl.hibernate.query.InExpressionBuilder;
import com.atlassian.confluence.internal.relations.RelatableEntityTypeEnum;
import com.atlassian.confluence.internal.relations.dao.User2ContentRelationEntity;
import com.atlassian.confluence.internal.relations.dao.hibernate.HibernateRelationDao;
import com.atlassian.confluence.internal.relations.dao.hibernate.RelationQueryHelper;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.core.bean.EntityObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Session;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.Query;
import org.springframework.dao.support.DataAccessUtils;

public class User2ContentHibernateRelationDao
extends HibernateRelationDao<ConfluenceUser, ContentEntityObject> {
    private final SchemaInformationService schemaInformationService;

    public User2ContentHibernateRelationDao(SessionFactoryImplementor sessionFactory, SchemaInformationService schemaInformationService) {
        super(sessionFactory);
        this.schemaInformationService = schemaInformationService;
    }

    @Override
    public int getRelationsCount(ConfluenceUser source, ContentEntityObject target, RelationDescriptor<?, ?> relationDescriptor) {
        return DataAccessUtils.intResult(this.getRelationEntities("confluence.relation.user2content.count", source, target, relationDescriptor));
    }

    public @Nullable User2ContentRelationEntity getRelationEntity(ConfluenceUser source, ContentEntityObject target, RelationDescriptor<?, ?> relationDescriptor) {
        return (User2ContentRelationEntity)DataAccessUtils.singleResult(this.getRelationEntities("confluence.relation.user2content.get.simple", source, target, relationDescriptor));
    }

    @Override
    public @NonNull List<ConfluenceUser> getSources(RelationQuery<ContentEntityObject> request, int start, int limit) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String queryStr = "select re.sourceContent " + RelationQueryHelper.buildConditionalQueryFor(request, parameters, true);
        return this.fetchList(ConfluenceUser.class, queryStr, parameters, start, limit);
    }

    @Override
    public @NonNull List<ContentEntityObject> getTargets(RelationQuery<ConfluenceUser> request, int start, int limit) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String queryStr = "select re.targetContent " + RelationQueryHelper.buildConditionalQueryFor(request, parameters, false);
        return this.fetchList(ContentEntityObject.class, queryStr, parameters, start, limit);
    }

    @Override
    public int getSourcesCount(RelationQuery<ContentEntityObject> request) {
        return this.getSourceOrTargetCount(request, true);
    }

    @Override
    public int getTargetsCount(RelationQuery<ConfluenceUser> request) {
        return this.getSourceOrTargetCount(request, false);
    }

    @Override
    public int removeAllRelations(RelatableEntity relatableEntity) {
        if (relatableEntity instanceof ConfluenceUser) {
            ConfluenceUser user = (ConfluenceUser)relatableEntity;
            return this.removeAllRelations(user);
        }
        if (relatableEntity instanceof ContentEntityObject) {
            ContentEntityObject ceo = (ContentEntityObject)relatableEntity;
            return this.removeAllRelations(ceo);
        }
        return 0;
    }

    private int removeAllRelations(ConfluenceUser relatableEntity) {
        return this.sessionFactory.getCurrentSession().createQuery("delete from User2ContentRelationEntity where sourceContent.key = :userKey").setParameter("userKey", (Object)relatableEntity.getKey()).executeUpdate();
    }

    private int removeAllRelations(ContentEntityObject relatableEntity) {
        return this.sessionFactory.getCurrentSession().createQuery("delete from User2ContentRelationEntity where targetContent.id = :contentId").setParameter("contentId", (Object)relatableEntity.getId()).executeUpdate();
    }

    public int updateDraftPageLastModTime(ContentEntityObject content, Date lastModificationDate, Date lastModificationDateForDraft) {
        String query = "update User2ContentRelationEntity re set re.lastModificationDate = :lastModificationDate where re.targetContent = :content and re.relationName = 'touched' and re.lastModificationDate >= :lastModificationDateForDraft";
        Query hibernateQuery = this.sessionFactory.getCurrentSession().createQuery(query);
        hibernateQuery.setParameter("content", (Object)content);
        hibernateQuery.setParameter("lastModificationDate", (Object)lastModificationDate);
        hibernateQuery.setParameter("lastModificationDateForDraft", (Object)lastModificationDateForDraft);
        return hibernateQuery.executeUpdate();
    }

    public int updateTargetTypeForContents(List<ContentEntityObject> contents, RelatableEntityTypeEnum targetType) {
        String query = "update User2ContentRelationEntity re set re.targetType = :targetType where re.targetContent in (:contents)";
        Query hibernateQuery = this.sessionFactory.getCurrentSession().createQuery(query);
        hibernateQuery.setParameter("contents", contents);
        hibernateQuery.setParameter("targetType", (Object)targetType);
        return hibernateQuery.executeUpdate();
    }

    @Override
    public int removeAllRelations(Iterable<? extends RelatableEntity> relatableEntities) {
        Objects.requireNonNull(relatableEntities);
        String[] deleteStatements = new String[]{"delete from User2ContentRelationEntity re where re.targetContent in (:contents)", "delete from User2ContentRelationEntity re where re.sourceContent in (:contents)"};
        List contentRelatableEntities = Streams.stream(relatableEntities).filter(relatableEntity -> relatableEntity instanceof ContentEntityObject).collect(Collectors.toList());
        List nonContentRelatableEntities = Streams.stream(relatableEntities).filter(relatableEntity -> !(relatableEntity instanceof ContentEntityObject)).collect(Collectors.toList());
        List params = List.of(contentRelatableEntities, nonContentRelatableEntities);
        int deleted = 0;
        for (int i = 0; i < params.size(); ++i) {
            String deleteStatement = deleteStatements[i];
            List toDeleteEntities = params.get(i);
            for (List innerRelatableEntities : Lists.partition(toDeleteEntities, (int)500)) {
                deleted += this.sessionFactory.getCurrentSession().createQuery(deleteStatement).setParameterList("contents", (Collection)innerRelatableEntities).executeUpdate();
            }
        }
        return deleted;
    }

    @Override
    public int removeAllRelationsFromEntityWithName(String relationName, RelatableEntity relatableEntity) {
        String query = relatableEntity instanceof ConfluenceUser ? "from User2ContentRelationEntity re where re.sourceContent = :relatableEntity and re.relationName = :relationName" : "from User2ContentRelationEntity re where re.targetContent = :relatableEntity and re.relationName = :relationName";
        List entities = this.sessionFactory.getCurrentSession().createQuery(query, User2ContentRelationEntity.class).setParameter("relatableEntity", (Object)relatableEntity).setParameter("relationName", (Object)relationName).list();
        entities.forEach(arg_0 -> ((Session)this.sessionFactory.getCurrentSession()).delete(arg_0));
        return entities.size();
    }

    @Override
    public int removeAllRelationsFromCurrentAndHistoricalEntities(RelatableEntity relatableEntity) {
        ContentEntityObject ceo;
        int deleted = this.removeAllRelations(relatableEntity);
        if (relatableEntity instanceof ContentEntityObject && (ceo = (ContentEntityObject)relatableEntity).isLatestVersion()) {
            String statement = "from User2ContentRelationEntity re where re.targetContent.originalVersion.id = :content and re.targetContent.contentStatus = 'current'";
            List entities = this.sessionFactory.getCurrentSession().createQuery(statement, User2ContentRelationEntity.class).setParameter("content", (Object)ceo.getId()).list();
            entities.forEach(arg_0 -> ((Session)this.sessionFactory.getCurrentSession()).delete(arg_0));
            deleted += entities.size();
        }
        return deleted;
    }

    @Override
    public int removeAllRelationsFromCurrentAndHistoricalEntities(Iterable<? extends RelatableEntity> relatableEntities) {
        Objects.requireNonNull(relatableEntities);
        int deleted = this.removeAllRelations(relatableEntities);
        Set innerRelatableEntities = Streams.stream(relatableEntities).filter(relatableEntity -> relatableEntity instanceof ContentEntityObject && ((ContentEntityObject)relatableEntity).isLatestVersion()).collect(Collectors.toSet());
        if (!innerRelatableEntities.isEmpty()) {
            for (List partitionRelatableEntities : Lists.partition(new ArrayList(innerRelatableEntities), (int)500)) {
                String statement = "from User2ContentRelationEntity re where re.targetContent.originalVersion in (:contents) and re.targetContent.contentStatus = 'current'";
                Query query = this.sessionFactory.getCurrentSession().createQuery(statement, User2ContentRelationEntity.class);
                query.setParameterList("contents", (Collection)partitionRelatableEntities);
                List resultList = query.list();
                resultList.forEach(arg_0 -> ((Session)this.sessionFactory.getCurrentSession()).delete(arg_0));
                deleted += resultList.size();
            }
        }
        return deleted;
    }

    public List<Long> getAllRelationIdsForContentInSpace(@NonNull String spaceKey, @NonNull Collection<ConfluenceEntityObject> exclusions, int start, int limit) {
        Object queryString = "select    re.id from    User2ContentRelationEntity re, SpaceContentEntityObject sceo where    re.targetContent = sceo    and (case when sceo.originalVersion is not null then sceo.originalVersion.id else sceo.id end) in (        select            ceo.id        from            SpaceContentEntityObject ceo, Space sp        where            ceo.space = sp            and sp.key = :spaceKey ";
        if (exclusions != null && !exclusions.isEmpty()) {
            List exclusionIds = exclusions.stream().map(EntityObject::getId).collect(Collectors.toList());
            InExpressionBuilder expr = InExpressionBuilder.getNotInExpressionBuilderDefaultLimit((String)"ceo.id", (String)"exclusions", (Dialect)this.schemaInformationService.getDialect());
            String exclusionInClause = expr.convertIdsToInClauseString(exclusionIds);
            queryString = (String)queryString + " and " + exclusionInClause + ")";
        } else {
            queryString = (String)queryString + ")";
        }
        Query hQuery = this.sessionFactory.getCurrentSession().createQuery((String)queryString);
        return hQuery.setParameter("spaceKey", (Object)spaceKey).setFirstResult(start).setMaxResults(limit).list();
    }

    protected User2ContentRelationEntity newRelationEntity(ConfluenceUser source, ContentEntityObject target) {
        User2ContentRelationEntity relationEntity = new User2ContentRelationEntity();
        relationEntity.setTargetType(RelatableEntityTypeEnum.getByContentEntityObject(target));
        relationEntity.setSourceType(RelatableEntityTypeEnum.USER);
        return relationEntity;
    }

    @Override
    protected RelationEntity<ConfluenceUser, ContentEntityObject> constructRelationEntity(RelationEntity<ConfluenceUser, ContentEntityObject> relationEntity, ConfluenceUser source, ContentEntityObject target, RelationDescriptor<?, ?> relationDescriptor) {
        relationEntity.setTargetContent(target);
        relationEntity.setSourceContent(source);
        relationEntity.setRelationName(relationDescriptor.getRelationName());
        relationEntity.setCreationDate(new Date());
        relationEntity.setLastModificationDate(new Date());
        if (relationEntity.getRelationName().equals("collaborator") || relationEntity.getRelationName().equals("contributor")) {
            relationEntity.setCreator(source);
            relationEntity.setLastModifier(source);
        } else {
            relationEntity.setCreator(AuthenticatedUserThreadLocal.get());
            relationEntity.setLastModifier(AuthenticatedUserThreadLocal.get());
        }
        return relationEntity;
    }
}

