/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.relations.dao.hibernate;

import com.atlassian.confluence.api.model.relations.RelationDescriptor;
import com.atlassian.confluence.dmz.relations.RelatableEntity;
import com.atlassian.confluence.dmz.relations.query.RelationQuery;
import com.atlassian.confluence.internal.relations.RelatableEntityTypeEnum;
import com.atlassian.confluence.internal.relations.dao.User2UserRelationEntity;
import com.atlassian.confluence.internal.relations.dao.hibernate.HibernateRelationDao;
import com.atlassian.confluence.user.ConfluenceUser;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.Query;
import org.springframework.dao.support.DataAccessUtils;

public class User2UserHibernateRelationDao
extends HibernateRelationDao<ConfluenceUser, ConfluenceUser> {
    public User2UserHibernateRelationDao(SessionFactoryImplementor sessionFactory) {
        super(sessionFactory);
    }

    @Override
    public int getRelationsCount(ConfluenceUser source, ConfluenceUser target, RelationDescriptor<?, ?> relationDescriptor) {
        return DataAccessUtils.intResult(this.getRelationEntities("confluence.relation.user2user.count", source, target, relationDescriptor));
    }

    public @Nullable User2UserRelationEntity getRelationEntity(ConfluenceUser source, ConfluenceUser target, RelationDescriptor<?, ?> relationDescriptor) {
        return (User2UserRelationEntity)DataAccessUtils.singleResult(this.getRelationEntities("confluence.relation.user2user.get.simple", source, target, relationDescriptor));
    }

    @Override
    public @NonNull List<ConfluenceUser> getSources(RelationQuery<ConfluenceUser> request, int start, int limit) {
        Query query = this.sessionFactory.getCurrentSession().createNamedQuery("confluence.relation.user2user.get.sources", ConfluenceUser.class);
        query.setParameter("target", (Object)request.getEntity());
        query.setParameter("relationName", (Object)request.getRelationDescriptor().getRelationName());
        return query.setFirstResult(start).setMaxResults(limit).list();
    }

    @Override
    public @NonNull List<ConfluenceUser> getTargets(RelationQuery<ConfluenceUser> request, int start, int limit) {
        Query query = this.sessionFactory.getCurrentSession().createNamedQuery("confluence.relation.user2user.get.targets", ConfluenceUser.class);
        query.setParameter("source", (Object)request.getEntity());
        query.setParameter("relationName", (Object)request.getRelationDescriptor().getRelationName());
        return query.setFirstResult(start).setMaxResults(limit).list();
    }

    @Override
    public int getSourcesCount(RelationQuery<ConfluenceUser> request) {
        Query query = this.sessionFactory.getCurrentSession().createNamedQuery("confluence.relation.user2user.get.sources.count", Integer.class);
        query.setParameter("target", (Object)request.getEntity());
        query.setParameter("relationName", (Object)request.getRelationDescriptor().getRelationName());
        return (Integer)query.getSingleResult();
    }

    @Override
    public int getTargetsCount(RelationQuery<ConfluenceUser> request) {
        Query query = this.sessionFactory.getCurrentSession().createNamedQuery("confluence.relation.user2user.get.targets.count", Integer.class);
        query.setParameter("source", (Object)request.getEntity());
        query.setParameter("relationName", (Object)request.getRelationDescriptor().getRelationName());
        return (Integer)query.getSingleResult();
    }

    @Override
    public int removeAllRelations(RelatableEntity relatableEntity) {
        if (!(relatableEntity instanceof ConfluenceUser)) {
            return 0;
        }
        return this.sessionFactory.getCurrentSession().createQuery("delete from User2UserRelationEntity re where re.sourceContent = :content or re.targetContent = :content").setParameter("content", (Object)relatableEntity).executeUpdate();
    }

    @Override
    public int removeAllRelations(Iterable<? extends RelatableEntity> relatableEntities) {
        Objects.requireNonNull(relatableEntities);
        List filteredRelatableEntities = Streams.stream(relatableEntities).filter(relatableEntity -> relatableEntity instanceof ConfluenceUser).collect(Collectors.toList());
        int deleted = 0;
        for (List innerRelatableEntities : Lists.partition((List)Lists.newArrayList(filteredRelatableEntities), (int)500)) {
            String deleteStatement = "delete from User2UserRelationEntity re where re.sourceContent in (:contents) OR re.targetContent in (:contents)";
            Query query = this.sessionFactory.getCurrentSession().createQuery(deleteStatement);
            query.setParameterList("contents", (Collection)innerRelatableEntities);
            deleted += query.executeUpdate();
        }
        return deleted;
    }

    @Override
    public int removeAllRelationsFromEntityWithName(String relationName, RelatableEntity relatableEntity) {
        if (!(relatableEntity instanceof ConfluenceUser)) {
            return 0;
        }
        String query = "from User2UserRelationEntity re where (re.sourceContent = :relatableEntity or re.targetContent = :relatableEntity) and re.relationName = :relationName";
        List entities = this.sessionFactory.getCurrentSession().createQuery(query, User2UserRelationEntity.class).setParameter("relatableEntity", (Object)relatableEntity).setParameter("relationName", (Object)relationName).list();
        entities.forEach(arg_0 -> ((Session)this.sessionFactory.getCurrentSession()).delete(arg_0));
        return entities.size();
    }

    @Override
    public int removeAllRelationsFromCurrentAndHistoricalEntities(RelatableEntity relatableEntity) {
        return this.removeAllRelations(relatableEntity);
    }

    @Override
    public int removeAllRelationsFromCurrentAndHistoricalEntities(Iterable<? extends RelatableEntity> relatableEntities) {
        return this.removeAllRelations(relatableEntities);
    }

    protected User2UserRelationEntity newRelationEntity(ConfluenceUser source, ConfluenceUser target) {
        User2UserRelationEntity relationEntity = new User2UserRelationEntity();
        relationEntity.setTargetType(RelatableEntityTypeEnum.USER);
        relationEntity.setSourceType(RelatableEntityTypeEnum.USER);
        return relationEntity;
    }
}

