/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.search;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.internal.search.SearchableResolver;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;

public final class AttachmentAwareSearchableResolver
implements SearchableResolver {
    private final AttachmentManager attachmentManager;

    public AttachmentAwareSearchableResolver(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    @Override
    public Collection<Searchable> getDependents(Searchable searchable) {
        if (searchable instanceof ContentEntityObject) {
            ContentEntityObject ceo = (ContentEntityObject)searchable;
            List<Attachment> attachments = this.attachmentManager.getLatestVersionsOfAttachmentsWithAnyStatus(ceo);
            return Lists.newArrayList((Iterable)Iterables.concat((Iterable)ceo.getSearchableDependants(), attachments));
        }
        return searchable.getSearchableDependants();
    }
}

