/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.search;

import com.atlassian.annotations.Internal;
import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.internal.search.IndexTaskFactoryInternal;
import com.atlassian.confluence.internal.search.LuceneIndependent;
import com.atlassian.confluence.internal.search.SearchableResolver;
import com.atlassian.confluence.search.ChangeIndexer;
import com.atlassian.confluence.search.ConfluenceIndexTask;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.confluence.search.IndexTaskQueue;
import com.atlassian.confluence.search.IndexerControl;
import com.atlassian.confluence.search.v2.SearchIndexAccessor;
import com.atlassian.confluence.spaces.Space;
import io.atlassian.util.concurrent.Lazy;
import jakarta.annotation.PostConstruct;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LuceneIndependent
@Internal
public class QueuingConfluenceIndexer
implements ConfluenceIndexer {
    private static final Logger log = LoggerFactory.getLogger(QueuingConfluenceIndexer.class);
    private IndexTaskQueue<ConfluenceIndexTask> taskQueue;
    private IndexTaskFactoryInternal indexTaskFactory;
    private IndexerControl indexerControl;
    private ChangeIndexer changeIndexer;
    private SearchIndexAccessor searchIndexAccessor;
    private Supplier<ConfluenceIndexer> asyncIndexer;
    private SearchableResolver searchableResolver;

    @PostConstruct
    void initDelegateIndexer() {
        this.asyncIndexer = Lazy.supplier(() -> new InternalConfluenceIndexer(indexTask -> this.taskQueue.enqueue((ConfluenceIndexTask)indexTask), this.changeIndexer, Lazy.supplier(() -> new InternalConfluenceIndexer(indexTask -> this.searchIndexAccessor.execute(indexTask::perform), this.changeIndexer.synchronous(), () -> this))));
    }

    @Override
    public void index(Searchable searchable) {
        if (searchable == null) {
            return;
        }
        this.asyncIndexer().index(searchable);
    }

    @Override
    public void unIndex(Searchable searchable) {
        if (searchable == null) {
            return;
        }
        this.asyncIndexer().unIndex(searchable);
    }

    @Override
    public void reIndex(Searchable searchable) {
        if (searchable == null) {
            return;
        }
        this.asyncIndexer().reIndex(searchable);
    }

    @Override
    public void reIndexExcludingDependents(Searchable searchable) {
        if (searchable == null) {
            return;
        }
        this.asyncIndexer().reIndexExcludingDependents(searchable);
    }

    @Override
    public void reIndexExcludingDependentsAndChangeIndex(Searchable searchable) {
        if (searchable == null) {
            return;
        }
        this.asyncIndexer().reIndexExcludingDependentsAndChangeIndex(searchable);
    }

    @Override
    public void unIndexSpace(Space space) {
        this.asyncIndexer().unIndexSpace(space);
    }

    @Override
    public void reindexUsersInGroup(String groupName) {
        this.asyncIndexer().reindexUsersInGroup(groupName);
    }

    @Override
    public void unIndexIncludingDependents(Searchable searchable) {
        if (searchable == null) {
            return;
        }
        this.asyncIndexer().unIndexIncludingDependents(searchable);
    }

    @Override
    public void indexIncludingDependents(Searchable searchable) {
        if (searchable == null) {
            return;
        }
        this.asyncIndexer().indexIncludingDependents(searchable);
    }

    @Override
    public void reIndexPermissions(Searchable obj) {
        if (obj == null) {
            return;
        }
        this.asyncIndexer.get().reIndexPermissions(obj);
    }

    @Override
    public ConfluenceIndexer synchronous() {
        return this.asyncIndexer().synchronous();
    }

    private ConfluenceIndexer asyncIndexer() {
        return this.asyncIndexer.get();
    }

    @VisibleForTesting
    public void setAsyncIndexer(Supplier<ConfluenceIndexer> asyncIndexer) {
        this.asyncIndexer = asyncIndexer;
    }

    public void setTaskQueue(IndexTaskQueue<ConfluenceIndexTask> taskQueue) {
        this.taskQueue = taskQueue;
    }

    public void setIndexTaskFactory(IndexTaskFactoryInternal indexTaskFactory) {
        this.indexTaskFactory = indexTaskFactory;
    }

    public void setSearchableResolver(SearchableResolver searchableResolver) {
        this.searchableResolver = searchableResolver;
    }

    public void setIndexerControl(IndexerControl indexerControl) {
        this.indexerControl = indexerControl;
    }

    public void setChangeIndexer(ChangeIndexer changeIndexer) {
        this.changeIndexer = changeIndexer;
    }

    public void setSearchIndexAccessor(SearchIndexAccessor searchIndexAccessor) {
        this.searchIndexAccessor = searchIndexAccessor;
    }

    private final class InternalConfluenceIndexer
    implements ConfluenceIndexer {
        private final Consumer<ConfluenceIndexTask> taskAction;
        private final ChangeIndexer changeIndexer;
        private final Supplier<ConfluenceIndexer> syncIndexer;

        InternalConfluenceIndexer(Consumer<ConfluenceIndexTask> taskAction, ChangeIndexer changeIndexer, Supplier<ConfluenceIndexer> syncIndexer) {
            this.taskAction = taskAction;
            this.changeIndexer = changeIndexer;
            this.syncIndexer = syncIndexer;
        }

        @Override
        public ConfluenceIndexer synchronous() {
            return this.syncIndexer.get();
        }

        @Override
        public void unIndexSpace(Space space) {
            if (QueuingConfluenceIndexer.this.indexerControl.indexingEnabled()) {
                log.trace("Queuing unindex space task: {}", (Object)space);
                this.changeIndexer.unIndexSpace(space);
                this.taskAction.accept(QueuingConfluenceIndexer.this.indexTaskFactory.createUnIndexSpaceContentIndexTask(space));
            } else {
                log.debug("Not queueing unindex space task: {}", (Object)space);
            }
        }

        @Override
        public void reindexUsersInGroup(String groupName) {
            if (QueuingConfluenceIndexer.this.indexerControl.indexingEnabled()) {
                log.trace("Queuing reindex group task: {}", (Object)groupName);
                this.changeIndexer.reindexUsersInGroup(groupName);
                this.taskAction.accept(QueuingConfluenceIndexer.this.indexTaskFactory.createReindexUsersInGroupContentTask(groupName));
            } else {
                log.debug("Not queueing reindex group task: {}", (Object)groupName);
            }
        }

        @Override
        public void unIndexIncludingDependents(Searchable searchable) {
            if (QueuingConfluenceIndexer.this.indexerControl.indexingDisabled()) {
                log.debug("Not queuing unindex with dependents: {}", (Object)searchable);
                return;
            }
            for (Searchable dependent : QueuingConfluenceIndexer.this.searchableResolver.getDependents(searchable)) {
                this.unIndexIncludingDependents(dependent);
            }
            this.unIndex(searchable);
        }

        @Override
        public void unIndex(Searchable searchable) {
            if (QueuingConfluenceIndexer.this.indexerControl.indexingDisabled()) {
                log.debug("Not queuing unindex: {}", (Object)searchable);
                return;
            }
            this.changeIndexer.unIndex(searchable);
            log.trace("Queueing searchable for un-indexing: {}", (Object)searchable);
            this.taskAction.accept(QueuingConfluenceIndexer.this.indexTaskFactory.createDeleteDocumentTask(searchable));
        }

        @Override
        public void reIndex(Searchable searchable) {
            this.doReindex(searchable, true, true);
        }

        @Override
        public void reIndexExcludingDependents(Searchable searchable) {
            this.doReindex(searchable, false, true);
        }

        @Override
        public void reIndexExcludingDependentsAndChangeIndex(Searchable obj) {
            this.doReindex(obj, false, false);
        }

        private void doReindex(Searchable searchable, boolean includeDependents, boolean includeChangeIndex) {
            if (QueuingConfluenceIndexer.this.indexerControl.indexingDisabled()) {
                log.debug("shouldIndex = false; Not queuing re-indexing: {}", (Object)searchable);
                return;
            }
            if (includeChangeIndex) {
                this.changeIndexer.reIndex(searchable);
            }
            if (searchable.isIndexable()) {
                log.trace("Queuing searchable for re-indexing: {}", (Object)searchable);
                this.taskAction.accept(QueuingConfluenceIndexer.this.indexTaskFactory.createUpdateDocumentTask(searchable, includeDependents));
            } else {
                log.debug("Not queuing searchable for re-indexing: {}", (Object)searchable);
            }
        }

        @Override
        public void indexIncludingDependents(Searchable searchable) {
            if (QueuingConfluenceIndexer.this.indexerControl.indexingDisabled()) {
                log.debug("Not queuing index with dependents: {}", (Object)searchable);
                return;
            }
            for (Searchable dependent : QueuingConfluenceIndexer.this.searchableResolver.getDependents(searchable)) {
                this.indexIncludingDependents(dependent);
            }
            this.index(searchable);
        }

        @Override
        public void reIndexPermissions(Searchable searchable) {
            if (QueuingConfluenceIndexer.this.indexerControl.indexingDisabled()) {
                log.debug("Not queuing re-index permissions only: {}", (Object)searchable);
                return;
            }
            this.changeIndexer.reIndex(searchable);
            log.trace("Queueing searchable for re-indexing permissions only: {}", (Object)searchable);
            this.taskAction.accept(QueuingConfluenceIndexer.this.indexTaskFactory.createReIndexPermissionsTask(searchable));
        }

        @Override
        public void index(Searchable searchable) {
            if (QueuingConfluenceIndexer.this.indexerControl.indexingDisabled()) {
                log.debug("shouldIndex = false; Not queuing index: {}", (Object)searchable);
                return;
            }
            this.changeIndexer.index(searchable);
            if (searchable.isIndexable()) {
                log.trace("Queueing searchable for indexing: {}", (Object)searchable);
                this.taskAction.accept(QueuingConfluenceIndexer.this.indexTaskFactory.createUpdateDocumentTask(searchable));
            } else {
                log.debug("Not queuing searchable for indexing: {}", (Object)searchable);
            }
        }
    }
}

