/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.search.contentnames.v2;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.core.persistence.hibernate.HibernateHandle;
import com.atlassian.confluence.search.contentnames.SearchResult;
import com.atlassian.confluence.search.v2.SearchFieldMappings;
import com.atlassian.confluence.search.v2.lucene.LuceneUtils;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.collect.ImmutableList;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

@Internal
class FieldValuesMapper
implements Function<Function<String, String>, Optional<SearchResult>> {
    private final List<BiFunction<Function<String, String>, SearchResult, SearchResult>> decorators;

    FieldValuesMapper() {
        this.decorators = Collections.emptyList();
    }

    FieldValuesMapper(BiFunction<Function<String, String>, SearchResult, SearchResult> one) {
        this.decorators = ImmutableList.of(one);
    }

    FieldValuesMapper(BiFunction<Function<String, String>, SearchResult, SearchResult> one, BiFunction<Function<String, String>, SearchResult, SearchResult> other) {
        this.decorators = ImmutableList.of(one, other);
    }

    @Override
    public Optional<SearchResult> apply(Function<String, String> getFieldValue) {
        String modificationDate;
        Long id;
        String contentName = getFieldValue.apply(SearchFieldMappings.CONTENT_NAME_UNSTEMMED.getName());
        String urlPath = getFieldValue.apply(SearchFieldMappings.CONTENT_URL_PATH.getName());
        String contentType = getFieldValue.apply(SearchFieldMappings.TYPE.getName());
        String handle = getFieldValue.apply(SearchFieldMappings.HANDLE.getName());
        try {
            id = new HibernateHandle(handle).getId();
        }
        catch (ParseException e) {
            return Optional.empty();
        }
        SearchResult result = new SearchResult(id, contentName, urlPath, contentType);
        String creationDate = getFieldValue.apply(SearchFieldMappings.CREATION_DATE.getName());
        if (creationDate != null) {
            result.setCreatedDate(LuceneUtils.stringToDate(creationDate));
        }
        if ((modificationDate = getFieldValue.apply(SearchFieldMappings.LAST_MODIFICATION_DATE.getName())) != null) {
            result.setLastModifiedDate(LuceneUtils.stringToDate(modificationDate));
        }
        result.setLastModifierKey(FieldValuesMapper.userKey(getFieldValue.apply(SearchFieldMappings.LAST_MODIFIER.getName())));
        result.setCreatorKey(FieldValuesMapper.userKey(getFieldValue.apply(SearchFieldMappings.CREATOR.getName())));
        for (BiFunction<Function<String, String>, SearchResult, SearchResult> decorator : this.decorators) {
            result = decorator.apply(getFieldValue, result);
        }
        return Optional.of(result);
    }

    private static UserKey userKey(String value) {
        return StringUtils.isBlank((CharSequence)value) ? null : new UserKey(value);
    }
}

