/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.search.tasks;

import com.atlassian.annotations.Internal;
import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.impl.search.queue.PrefetchAtlassianDocumentRetriever;
import com.atlassian.confluence.internal.search.LuceneIndependent;
import com.atlassian.confluence.internal.search.tasks.AddChangeDocumentIndexTask;
import com.atlassian.confluence.search.v2.AtlassianDocument;
import com.atlassian.confluence.search.v2.SearchIndexWriter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Optional;

@SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
@LuceneIndependent
@Internal
public class AddPrefetchChangeDocumentIndexTask
extends AddChangeDocumentIndexTask {
    private final PrefetchAtlassianDocumentRetriever prefetchRetriever;

    public AddPrefetchChangeDocumentIndexTask(Searchable searchable, PrefetchAtlassianDocumentRetriever prefetchRetriever, boolean skipDeletes) {
        super(searchable, null, skipDeletes);
        this.prefetchRetriever = prefetchRetriever;
    }

    @Override
    protected void writeChangeDocument(SearchIndexWriter writer, Searchable searchable) throws IOException {
        Optional<AtlassianDocument> atlassianDocumentOptional = this.prefetchRetriever.prefetch(searchable);
        if (atlassianDocumentOptional.isPresent()) {
            writer.add(atlassianDocumentOptional.get());
        }
    }
}

