/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.search.tasks;

import com.atlassian.annotations.Internal;
import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.impl.search.queue.PrefetchAtlassianDocumentRetriever;
import com.atlassian.confluence.internal.search.LuceneIndependent;
import com.atlassian.confluence.internal.search.tasks.AddDocumentIndexTask;
import com.atlassian.confluence.search.v2.AtlassianDocument;
import com.atlassian.confluence.search.v2.SearchIndexWriter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
@LuceneIndependent
@Internal
public class AddPrefetchedDocumentIndexTask
extends AddDocumentIndexTask {
    private static final Logger log = LoggerFactory.getLogger(AddPrefetchedDocumentIndexTask.class);
    private final PrefetchAtlassianDocumentRetriever prefetchAtlassianDocumentRetriever;

    public AddPrefetchedDocumentIndexTask(Searchable searchable, PrefetchAtlassianDocumentRetriever prefetchAtlassianDocumentRetriever) {
        super(searchable);
        this.prefetchAtlassianDocumentRetriever = Objects.requireNonNull(prefetchAtlassianDocumentRetriever, "PrefetchAtlassianDocumentRetriever instance cannot be null");
    }

    @Override
    public void perform(SearchIndexWriter writer) throws IOException {
        try {
            Optional<AtlassianDocument> atlassianDocumentOptional = this.prefetchAtlassianDocumentRetriever.prefetch(this.searchable);
            if (atlassianDocumentOptional.isPresent()) {
                writer.add(atlassianDocumentOptional.get());
            }
        }
        catch (Exception e) {
            log.warn("Error getting document from searchable", (Throwable)e);
        }
    }
}

