/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.search.tasks;

import com.atlassian.annotations.Internal;
import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.bonnie.Handle;
import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.api.model.journal.JournalIdentifier;
import com.atlassian.confluence.core.AbstractVersionedEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.persistence.hibernate.HibernateHandle;
import com.atlassian.confluence.impl.hibernate.HibernateSessionManager5;
import com.atlassian.confluence.internal.persistence.ContentEntityObjectDaoInternal;
import com.atlassian.confluence.internal.search.ChangeDocumentIndexPolicy;
import com.atlassian.confluence.internal.search.IndexTaskFactoryInternal;
import com.atlassian.confluence.internal.search.LuceneIndependent;
import com.atlassian.confluence.search.ConfluenceIndexTask;
import com.atlassian.confluence.search.HandleAware;
import com.atlassian.confluence.search.queue.JournalEntryFactory;
import com.atlassian.confluence.search.queue.JournalEntryType;
import com.atlassian.confluence.search.v2.SearchIndexWriter;
import com.atlassian.confluence.search.v2.lucene.SearchIndex;
import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LuceneIndependent
@Internal
public class RebuildChangeDocumentsIndexTask
implements ConfluenceIndexTask,
HandleAware {
    private static final Logger log = LoggerFactory.getLogger(RebuildChangeDocumentsIndexTask.class);
    private static final JournalEntryType journalEntryType = JournalEntryType.REBUILD_CHANGE_DOCUMENTS;
    private final Handle handle;
    private final Searchable searchable;
    private final ContentEntityObjectDaoInternal contentEntityObjectDao;
    private final IndexTaskFactoryInternal indexTaskFactory;
    private final HibernateSessionManager5 hibernateSessionManager;
    private final boolean skipDeletes;
    @VisibleForTesting
    int LAST_EDITED_VERSION_BATCH_SIZE = 100;

    public RebuildChangeDocumentsIndexTask(Searchable searchable, ContentEntityObjectDaoInternal contentEntityObjectDao, IndexTaskFactoryInternal indexTaskFactory, HibernateSessionManager5 hibernateSessionManager, boolean skipDeletes) {
        this.hibernateSessionManager = hibernateSessionManager;
        this.skipDeletes = skipDeletes;
        if (searchable == null) {
            throw new IllegalArgumentException("searchable cannot be null.");
        }
        if (!ChangeDocumentIndexPolicy.shouldIndex(searchable)) {
            throw new IllegalArgumentException("searchable is not supported. Received: " + String.valueOf(searchable));
        }
        this.searchable = searchable;
        this.handle = new HibernateHandle(searchable);
        this.contentEntityObjectDao = contentEntityObjectDao;
        this.indexTaskFactory = indexTaskFactory;
    }

    @Override
    public Handle getHandle() {
        return this.handle;
    }

    @Override
    public String getDescription() {
        return "index.task.rebuild.change";
    }

    @Override
    public void perform(SearchIndexWriter writer) throws IOException {
        if (!this.skipDeletes) {
            this.indexTaskFactory.createDeleteChangeDocumentsIndexTask(this.searchable).perform(writer);
        }
        if (!(this.searchable instanceof ContentEntityObject)) {
            throw new UnsupportedOperationException(String.valueOf(this.searchable) + " not supported");
        }
        Collection<ContentEntityObject> searchables = this.contentEntityObjectDao.getLastEditedVersionsOf((ContentEntityObject)this.searchable);
        if (this.skipDeletes) {
            searchables = searchables.stream().collect(Collectors.toMap(AbstractVersionedEntityObject::getVersion, Function.identity(), (s, t) -> s)).values();
        }
        this.hibernateSessionManager.executeThenClearSessionWithoutCommitOrFlush(searchables, this.LAST_EDITED_VERSION_BATCH_SIZE, searchables.size(), ceo -> {
            if (ChangeDocumentIndexPolicy.shouldIndex(ceo)) {
                try {
                    this.indexTaskFactory.createAddChangeDocumentTask((Searchable)ceo).perform(writer);
                }
                catch (IOException e) {
                    log.warn("Error when indexing change document for document with id: {} and last edited version id of: {}.", (Object)this.searchable.getId(), (Object)ceo.getId());
                }
            }
            return null;
        });
    }

    @Override
    public Optional<JournalEntry> convertToJournalEntry(JournalIdentifier journalId) {
        return JournalEntryFactory.createJournalEntry(journalId, journalEntryType, this.handle.toString());
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.handle).append((Object)RebuildChangeDocumentsIndexTask.class.getName()).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RebuildChangeDocumentsIndexTask)) {
            return false;
        }
        RebuildChangeDocumentsIndexTask that = (RebuildChangeDocumentsIndexTask)obj;
        return new EqualsBuilder().append((Object)this.handle, (Object)that.handle).isEquals();
    }

    @Override
    public SearchIndex getSearchIndex() {
        return SearchIndex.CHANGE;
    }
}

