/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.search.tasks;

import com.atlassian.annotations.Internal;
import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.api.model.journal.JournalIdentifier;
import com.atlassian.confluence.core.BatchOperationManager;
import com.atlassian.confluence.internal.search.ChangeDocumentIndexPolicy;
import com.atlassian.confluence.internal.search.IndexTaskFactoryInternal;
import com.atlassian.confluence.internal.search.LuceneIndependent;
import com.atlassian.confluence.internal.search.SearchableResolver;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.persistence.dao.BlogPostDao;
import com.atlassian.confluence.search.ConfluenceIndexTask;
import com.atlassian.confluence.search.queue.JournalEntryFactory;
import com.atlassian.confluence.search.queue.JournalEntryType;
import com.atlassian.confluence.search.v2.SearchIndexWriter;
import com.atlassian.confluence.search.v2.lucene.SearchIndex;
import com.atlassian.spring.container.ContainerManager;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LuceneIndependent
@Internal
public class ReindexAllBlogsChangeIndexTask
implements ConfluenceIndexTask {
    private static final Logger log = LoggerFactory.getLogger(ReindexAllBlogsChangeIndexTask.class);
    private static final JournalEntryType journalEntryType = JournalEntryType.REINDEX_ALL_BLOGS_CHANGE;
    private final BlogPostDao blogPostDao;
    private final IndexTaskFactoryInternal indexTaskFactory;
    private final SearchableResolver searchableResolver;
    private final BatchOperationManager batchOperationManager;

    public ReindexAllBlogsChangeIndexTask(IndexTaskFactoryInternal indexTaskFactory, SearchableResolver searchableResolver, BatchOperationManager batchOperationManager) {
        this.indexTaskFactory = indexTaskFactory;
        this.searchableResolver = searchableResolver;
        this.batchOperationManager = batchOperationManager;
        this.blogPostDao = (BlogPostDao)ContainerManager.getComponent((String)"blogPostDao");
    }

    @Override
    public void perform(SearchIndexWriter writer) {
        log.info("Start reindexing changes - all blogs");
        List<Long> blogIds = this.blogPostDao.getCurrentBlogPostIds();
        this.batchOperationManager.applyInBatches(blogIds, blogIds.size(), id -> {
            BlogPost blog = this.blogPostDao.getById((long)id);
            this.indexContentAndDependents(blog, writer);
            return null;
        });
        log.info("Complete reindexing changes - all blogs");
    }

    private void indexContentAndDependents(Searchable searchable, SearchIndexWriter writer) {
        if (ChangeDocumentIndexPolicy.shouldIndex(searchable)) {
            try {
                this.indexTaskFactory.createAddChangeDocumentTask(searchable).perform(writer);
            }
            catch (IOException e) {
                log.error("Unable to reindex item {}", (Object)searchable, (Object)e);
            }
            this.searchableResolver.getDependents(searchable).forEach(item -> {
                if (item instanceof Searchable) {
                    this.indexContentAndDependents((Searchable)item, writer);
                }
            });
        }
    }

    @Override
    public String getDescription() {
        return "index.task.reindex.blog.change";
    }

    @Override
    public Optional<JournalEntry> convertToJournalEntry(JournalIdentifier journalId) {
        return JournalEntryFactory.createJournalEntry(journalId, journalEntryType, null);
    }

    @Override
    public SearchIndex getSearchIndex() {
        return SearchIndex.CHANGE;
    }
}

