/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.search.tasks;

import com.atlassian.annotations.Internal;
import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.api.model.journal.JournalIdentifier;
import com.atlassian.confluence.core.persistence.hibernate.HibernateHandle;
import com.atlassian.confluence.internal.search.LuceneIndependent;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.atlassian.confluence.search.ConfluenceIndexTask;
import com.atlassian.confluence.search.queue.JournalEntryFactory;
import com.atlassian.confluence.search.queue.JournalEntryType;
import com.atlassian.confluence.search.v2.AtlassianDocument;
import com.atlassian.confluence.search.v2.AtlassianDocumentBuilder;
import com.atlassian.confluence.search.v2.SearchFieldMappings;
import com.atlassian.confluence.search.v2.SearchIndexWriter;
import com.atlassian.confluence.search.v2.lucene.SearchIndex;
import com.atlassian.confluence.security.ContentPermissionSet;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LuceneIndependent
@Internal
public class ReindexPermissionsIndexTask
implements ConfluenceIndexTask {
    private static final Logger log = LoggerFactory.getLogger(ReindexPermissionsIndexTask.class);
    private static final JournalEntryType journalEntryType = JournalEntryType.REINDEX_PERMISSIONS;
    private final AtlassianDocumentBuilder<Searchable> documentBuilder;
    private final Searchable searchable;
    private final HibernateHandle handle;

    public ReindexPermissionsIndexTask(Searchable searchable, AtlassianDocumentBuilder<Searchable> documentBuilder) {
        this.documentBuilder = documentBuilder;
        this.searchable = searchable;
        this.handle = new HibernateHandle(searchable);
    }

    @Override
    public String getDescription() {
        return "index.task.reindex.permissions.only";
    }

    @Override
    public void perform(SearchIndexWriter writer) {
        try {
            AtlassianDocument partialUpdate = this.documentBuilder.build(this.searchable);
            boolean noPermissionsSet = partialUpdate.getFields().stream().map(rec$ -> ((FieldDescriptor)rec$).getName()).noneMatch(f -> f.equals(SearchFieldMappings.PERMISSION_SETS.getName()));
            if (noPermissionsSet) {
                partialUpdate.addField(SearchFieldMappings.PERMISSION_SETS.createField(new ContentPermissionSet()));
            }
            writer.update(this.handle.toString(), partialUpdate);
        }
        catch (Exception e) {
            log.warn("Error updating document from searchable", (Throwable)e);
        }
    }

    @Override
    public Optional<JournalEntry> convertToJournalEntry(JournalIdentifier journalId) {
        return JournalEntryFactory.createJournalEntry(journalId, journalEntryType, this.handle.toString());
    }

    @Override
    public SearchIndex getSearchIndex() {
        return SearchIndex.CONTENT;
    }
}

