/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.search.tasks;

import com.atlassian.annotations.Internal;
import com.atlassian.bonnie.Handle;
import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.api.model.journal.JournalIdentifier;
import com.atlassian.confluence.core.persistence.hibernate.HibernateHandle;
import com.atlassian.confluence.internal.search.IndexTaskFactoryInternal;
import com.atlassian.confluence.internal.search.LuceneIndependent;
import com.atlassian.confluence.internal.search.SearchableResolver;
import com.atlassian.confluence.search.ConfluenceIndexTask;
import com.atlassian.confluence.search.HandleAware;
import com.atlassian.confluence.search.queue.JournalEntryFactory;
import com.atlassian.confluence.search.queue.JournalEntryType;
import com.atlassian.confluence.search.v2.SearchIndexWriter;
import com.atlassian.confluence.search.v2.lucene.SearchIndex;
import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LuceneIndependent
@Internal
public class UpdateDocumentIndexTask
implements ConfluenceIndexTask,
HandleAware {
    private static final Logger log = LoggerFactory.getLogger(UpdateDocumentIndexTask.class);
    protected final JournalEntryType journalEntryType;
    protected final Searchable searchable;
    protected final Handle handle;
    protected final IndexTaskFactoryInternal indexTaskFactory;
    protected final boolean includeDependents;
    protected final boolean skipDeletes;
    private final SearchableResolver searchableResolver;

    public UpdateDocumentIndexTask(Searchable searchable, IndexTaskFactoryInternal indexTaskFactory) {
        this(searchable, indexTaskFactory, true);
    }

    public UpdateDocumentIndexTask(Searchable searchable, IndexTaskFactoryInternal indexTaskFactory, boolean includeDependents) {
        this(searchable, indexTaskFactory, includeDependents, false);
    }

    public UpdateDocumentIndexTask(Searchable searchable, IndexTaskFactoryInternal indexTaskFactory, boolean includeDependents, boolean skipDeletes) {
        this(searchable, Searchable::getSearchableDependants, indexTaskFactory, includeDependents, skipDeletes);
    }

    UpdateDocumentIndexTask(Searchable searchable, SearchableResolver searchableResolver, IndexTaskFactoryInternal indexTaskFactory, boolean includeDependents, boolean skipDeletes) {
        this.searchableResolver = searchableResolver;
        if (searchable == null) {
            throw new IllegalArgumentException("searchable cannot be null.");
        }
        if (!searchable.isIndexable()) {
            throw new IllegalArgumentException("The following item is not indexable: " + String.valueOf(searchable));
        }
        if (indexTaskFactory == null) {
            throw new IllegalArgumentException("indexTaskFactory cannot be null.");
        }
        this.searchable = searchable;
        this.indexTaskFactory = indexTaskFactory;
        this.handle = new HibernateHandle(searchable);
        this.includeDependents = includeDependents;
        this.journalEntryType = includeDependents ? JournalEntryType.UPDATE_DOCUMENT : JournalEntryType.UPDATE_DOCUMENT_EXCLUDING_DEPENDENTS;
        this.skipDeletes = skipDeletes;
    }

    @Override
    public String getDescription() {
        return "index.task.update";
    }

    @Override
    public void perform(SearchIndexWriter writer) throws IOException {
        if (!this.skipDeletes) {
            log.debug("Deleting document with handle: {}", (Object)this.handle.toString());
            this.indexTaskFactory.createDeleteDocumentTask(this.handle.toString()).perform(writer);
        }
        log.debug("Adding document for searchable: {}", (Object)this.searchable);
        this.indexTaskFactory.createAddDocumentTask(this.searchable).perform(writer);
        if (this.includeDependents) {
            Collection<Searchable> dependants = this.searchableResolver.getDependents(this.searchable);
            log.debug("Re-indexing {} dependants", (Object)dependants.size());
            for (Searchable s : dependants) {
                Searchable sble;
                if (!(s instanceof Searchable) || !(sble = s).isIndexable()) continue;
                log.trace("Re-indexing {}", (Object)sble);
                if (!this.skipDeletes) {
                    this.indexTaskFactory.createDeleteDocumentTask(sble).perform(writer);
                }
                this.indexTaskFactory.createAddDocumentTask(sble).perform(writer);
            }
        }
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    public Optional<JournalEntry> convertToJournalEntry(JournalIdentifier journalId) {
        return JournalEntryFactory.createJournalEntry(journalId, this.journalEntryType, this.handle.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof UpdateDocumentIndexTask)) {
            return false;
        }
        UpdateDocumentIndexTask that = (UpdateDocumentIndexTask)o;
        return this.handle.equals((Object)that.handle) && this.includeDependents == that.includeDependents;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)UpdateDocumentIndexTask.class.getName()).append((Object)this.handle).append(this.includeDependents).toHashCode();
    }

    @Override
    public Handle getHandle() {
        return this.handle;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("handle", (Object)this.handle).toString();
    }

    @Override
    public SearchIndex getSearchIndex() {
        return SearchIndex.CONTENT;
    }
}

