/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.search.tasks;

import com.atlassian.annotations.Internal;
import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.impl.search.queue.PrefetchAtlassianDocumentRetriever;
import com.atlassian.confluence.internal.search.IndexTaskFactoryInternal;
import com.atlassian.confluence.internal.search.LuceneIndependent;
import com.atlassian.confluence.internal.search.SearchableResolver;
import com.atlassian.confluence.internal.search.tasks.UpdateDocumentIndexTask;
import com.atlassian.confluence.search.v2.SearchIndexWriter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
@LuceneIndependent
@Internal
public class UpdatePrefetchDocumentIndexTask
extends UpdateDocumentIndexTask {
    private static final Logger log = LoggerFactory.getLogger(UpdatePrefetchDocumentIndexTask.class);
    private final PrefetchAtlassianDocumentRetriever prefetchAtlassianDocumentRetriever;
    private final SearchableResolver searchableResolver;

    @VisibleForTesting
    UpdatePrefetchDocumentIndexTask(Searchable searchable, IndexTaskFactoryInternal indexTaskFactory, PrefetchAtlassianDocumentRetriever prefetchAtlassianDocumentRetriever, boolean includeDependents, boolean skipDeletes) {
        this(searchable, Searchable::getSearchableDependants, indexTaskFactory, prefetchAtlassianDocumentRetriever, includeDependents, skipDeletes);
    }

    public UpdatePrefetchDocumentIndexTask(Searchable searchable, SearchableResolver searchableResolver, IndexTaskFactoryInternal indexTaskFactory, PrefetchAtlassianDocumentRetriever prefetchAtlassianDocumentRetriever, boolean includeDependents, boolean skipDeletes) {
        super(searchable, indexTaskFactory, includeDependents, skipDeletes);
        this.prefetchAtlassianDocumentRetriever = Objects.requireNonNull(prefetchAtlassianDocumentRetriever);
        this.searchableResolver = Objects.requireNonNull(searchableResolver);
    }

    @Override
    public void perform(SearchIndexWriter writer) throws IOException {
        if (!this.skipDeletes) {
            log.debug("Deleting document with handle: {}", (Object)this.handle.toString());
            this.indexTaskFactory.createDeleteDocumentTask(this.handle.toString()).perform(writer);
        }
        log.debug("Adding document for searchable: {}", (Object)this.searchable);
        this.indexTaskFactory.createAddDocumentTask(this.searchable, this.prefetchAtlassianDocumentRetriever).perform(writer);
        if (this.includeDependents) {
            Collection<Searchable> dependants = this.searchableResolver.getDependents(this.searchable);
            log.debug("Re-indexing {} dependants", (Object)dependants.size());
            for (Searchable s : dependants) {
                Searchable sble;
                if (!(s instanceof Searchable) || !(sble = s).isIndexable()) continue;
                log.trace("Re-indexing {}", (Object)sble);
                if (!this.skipDeletes) {
                    this.indexTaskFactory.createDeleteDocumentTask(sble).perform(writer);
                }
                this.indexTaskFactory.createAddDocumentTask(sble).perform(writer);
            }
        }
    }
}

